% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeconvoluteSpectrum.R
\name{DeconvoluteSpectrum}
\alias{DeconvoluteSpectrum}
\title{Deconvolute a Mass Spectrum from a list of raw data files.}
\usage{
DeconvoluteSpectrum(
  dat = NULL,
  rt = NULL,
  rt_dev = 3,
  mz1 = NULL,
  mz_dev = 0.003,
  use.mz.adjust = FALSE,
  ionization = c("APCI", "ESI")[1],
  smooth = 0
)
}
\arguments{
\item{dat}{A list of `xcmsRaw` or `xcmsRawLike` objects.}

\item{rt}{Retention time of the expected peak.}

\item{rt_dev}{Allowed retention time deviation.}

\item{mz1}{If specified, ensure that this mass is included in the spectrum (assumed base peak). Can be NULL otherwise in which case the most intense peak at rt will be selected as mz1.}

\item{mz_dev}{Allowed mz deviation [Da].}

\item{use.mz.adjust}{Will adjust mz on an experiment wide basis.}

\item{ionization}{Either APCI or ESI. Choice will modify some internal parameters and checks performed.}

\item{smooth}{Smoothing parameter passed on to \link{getMultipleBPC}.}
}
\value{
A pseudo spectrum at rt (containing mz1 if specified). Effectively
    a 2-column matrix (mz, int) with rt as attribute.
}
\description{
\code{DeconvoluteSpectrum} will evaluate a list of `xcmsRaw` or
    `xcmsRawLike` objects at a given time (rt) and potential mass (mz1). The
    main purpose is to deconvolute the mass spectrum at rt including mz1.
}
\details{
The specific advantage of \code{DeconvoluteSpectrum} is, that it does
    not deconvolute signals within a single measurement file but uses correlation
    tests over a set of measurements to improve statistical power. It will test
    all mz around a specified rt to co-apex with some mz1, have a low rt
    difference and consistent intensity ratio over all samples.
}
\examples{
# The example measurement data provided with HiResTEC contain a peak at 1026s
raw <- HiResTEC::raw
HiResTEC::DeconvoluteSpectrum(raw, rt = 1026)

}
