% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_kinetic_data.R
\name{show_uc_data}
\alias{show_uc_data}
\title{Deuterium uptake curve data}
\usage{
show_uc_data(uc_dat, theoretical = FALSE, fractional = FALSE)
}
\arguments{
\item{uc_dat}{calculated kinetic data by \code{\link{calculate_kinetics}} 
or \code{\link{calculate_peptide_kinetics}} or 
\code{\link{create_kinetic_dataset}} function}

\item{theoretical}{\code{logical}, indicator if values are 
calculated using theoretical controls}

\item{fractional}{\code{logical}, indicator if values are shown 
in fractional form}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Present deuterium uptake curve data
}
\details{
The function \code{\link{show_uptake_data}} generates a subsets
of the uc_dat based on selected parameters.
The numerical values are rounded to 4 places. The names of columns
are changed to user-friendly ones.
}
\examples{
uc_dat <- calculate_kinetics(alpha_dat,
                             sequence = "GFGDLKSPAGL", 
                             state = "ALPHA_Gamma",
                             start = 1, end = 11)
show_uc_data(uc_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_kinetics}}
\code{\link{calculate_peptide_kinetics}}
}
