% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_data.R
\name{show_summary_data}
\alias{show_summary_data}
\title{Summary data}
\usage{
show_summary_data(
  dat,
  confidence_level = "",
  protein_length = max(dat[["End"]])
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function}

\item{confidence_level}{confidence level for the test, from range [0, 1].}

\item{protein_length}{the length of the protein sequence}
}
\value{
a \code{\link[data.table]{data.table}} object
}
\description{
Show summary table
}
\details{
The format in the table is suggested by the community and 
should be provided for experimental data.
}
\examples{
show_summary_data(alpha_dat)

}
\references{
Masson, G.R., Burke, J.E., Ahn, N.G., Anand, G.S., Borchers, C., 
Brier, S., Bou-Assaf, G.M., Engen, J.R., Englander, S.W., Faber, J., 
et al. (2019). Recommendations for performing, interpreting and reporting 
hydrogen deuterium exchange mass spectrometry (HDX-MS) experiments. 
Nat Methods 16, 595–602
}
\seealso{
\code{\link{read_hdx}}
}
