% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{plot_overlap_distribution}
\alias{plot_overlap_distribution}
\title{Plot overlap distribution}
\usage{
plot_overlap_distribution(
  overlap_dist_dat,
  start = 1,
  end = max(overlap_dist_dat[["pos"]]),
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{overlap_dist_dat}{produced by \code{\link{create_overlap_distribution_dataset}}
function}

\item{start}{start start position of chosen protein.}

\item{end}{end position of chosen protein.}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Generates overlap distribution plot based on supplied data
and parameters.
}
\details{
This plot presents how many times (by how many peptides) 
a amino position in protein sequence is covered. 
This plot is visible in GUI.
}
\examples{
overlap_dist_dat <- create_overlap_distribution_dataset(alpha_dat)
plot_overlap_distribution(overlap_dist_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{reconstruct_sequence}} 
\code{\link{create_overlap_distribution_dataset}}
}
