% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicates.R
\name{create_replicate_dataset}
\alias{create_replicate_dataset}
\title{Create replicates data}
\usage{
create_replicate_dataset(
  dat,
  time_t = NULL,
  protein = unique(dat[["Protein"]])[1],
  state = dat[["State"]][1]
)
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function.}

\item{time_t}{optional, for only one time point of
measurement. If value is NULL, all time point from
\code{dat} are preserved.}

\item{protein}{chosen protein.}

\item{state}{biological state for chosen protein.}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Create replicate data set suitable
for replicate histogram, for one or multiple 
time points of measurement.
}
\details{
The function \code{\link{create_replicate_dataset}}
creates a dataset with information about how many
replicates are for peptides in specific state in 
time points of measurement.
}
\examples{
create_replicate_dataset(alpha_dat)

}
\seealso{
\code{\link{plot_replicate_histogram}}
\code{\link{show_replicate_histogram_data}}
}
