% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/31_pre_processing_functions.R
\name{check_data_for_folds}
\alias{check_data_for_folds}
\title{Check that data has enough rows for cross-validation folds}
\usage{
check_data_for_folds(data, n_folds)
}
\arguments{
\item{data}{A data frame or matrix.}

\item{n_folds}{Integer. The number of folds to check for.}
}
\value{
NULL (called for its side effect). Throws an error if the number of rows is too small.
}
\description{
Validates that the input data has at least as many rows as the number of desired folds.
}
\examples{
check_data_for_folds(matrix(1:20, nrow = 5), n_folds = 5)
\dontrun{
check_data_for_folds(matrix(1:4, nrow = 2), n_folds = 5)  # This will throw an error
}

}
