% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_weights_portfol.R
\name{new_MV_portfolio_weights_BDOPS21}
\alias{new_MV_portfolio_weights_BDOPS21}
\alias{new_MV_portfolio_weights_BDOPS21_pgn}
\title{Constructor of MV portfolio object}
\usage{
new_MV_portfolio_weights_BDOPS21(x, gamma, b, beta)

new_MV_portfolio_weights_BDOPS21_pgn(x, gamma, b, beta)
}
\arguments{
\item{x}{a p by n matrix or a data frame of asset returns. Rows represent
different assets, columns -- observations.}

\item{gamma}{a numeric variable. Coefficient of risk aversion.}

\item{b}{a numeric variable. 1-beta is the confidence level of the symmetric
confidence interval, constructed for each weight.}

\item{beta}{a numeric variable. The confidence level for weight intervals.}
}
\value{
an object of class MeanVar_portfolio with subclass
MV_portfolio_weights_BDOPS21.\tabular{ll}{
   Element \tab Description \cr
   call \tab the function call with which it was created \cr
   cov_mtrx \tab the sample covariance matrix of the asset returns \cr
   inv_cov_mtrx \tab the inverse of the sample covariance matrix \cr
   means \tab sample mean vector of the asset returns \cr
   W_mv_hat \tab sample estimator of the portfolio weights \cr
   weights \tab shrinkage estimator of the portfolio weights \cr
   alpha \tab shrinkage intensity for the weights \cr
   Port_Var \tab portfolio variance \cr
   Port_mean_return \tab expected portfolio return \cr
   Sharpe \tab portfolio Sharpe ratio \cr
   weight_intervals \tab A data frame, see details \cr
}


weight_intervals contains a shrinkage estimator of portfolio weights,
asymptotic confidence intervals for the true portfolio weights, value of
the test statistic and the p-value of the test on the equality of
the weight of each individual asset to zero
\insertCite{@see Section 4.3 of @CORRBDNT23}{HDShOP}
weight_intervals is only computed when p<n.
}
\description{
Constructor of mean-variance shrinkage portfolios.
new_MV_portfolio_weights_BDOPS21 is for the case p<n, while
new_MV_portfolio_weights_BDOPS21_pgn is for p>n, where p is the number of
assets and n is the number of observations.
For more details of the method, see \code{\link{MVShrinkPortfolio}}.
}
\examples{

# c<1

# Assets with a diagonal covariance matrix

n <- 3e2 # number of realizations
p <- .5*n # number of assets
b <- rep(1/p,p)
gamma <- 1

x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

test <- new_MV_portfolio_weights_BDOPS21(x=x, gamma=gamma, b=b, beta=0.05)
summary(test)

# Assets with a non-diagonal covariance matrix

Mtrx <- RandCovMtrx(p=p)
x <- t(MASS::mvrnorm(n=n , mu=rep(0,p), Sigma=Mtrx))

test <- new_MV_portfolio_weights_BDOPS21(x=x, gamma=gamma, b=b, beta=0.05)
str(test)


# c>1

n <-2e2 # number of realizations
p <-1.2*n # number of assets
b <-rep(1/p,p)
x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

test <- new_MV_portfolio_weights_BDOPS21_pgn(x=x, gamma=gamma,
                                             b=b, beta=0.05)
summary(test)

# Assets with a non-diagonal covariance matrix

}
\references{
\insertRef{BDOPS2021}{HDShOP}

\insertRef{CORRBDNT23}{HDShOP}
}
