% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_author_info.R
\name{get_author_info}
\alias{get_author_info}
\title{Get Author Information from Goodreads}
\usage{
get_author_info(file_path)
}
\arguments{
\item{file_path}{A character string specifying the path to the file containing Goodreads book IDs.}
}
\value{
A named list where each element contains the author information for a book.
}
\description{
This function takes a file path containing Goodreads book IDs and retrieves
the author information for each book.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)
# Run the function
author_info <- get_author_info(temp_file)
print(author_info)
# Clean up: remove the temporary file
file.remove(temp_file)
}
}
