% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_statistics.R
\name{count_category}
\alias{count_category}
\title{Frequency of categorical variables}
\usage{
count_category(x, width = 15, collapse = FALSE, sort = TRUE, format = TRUE)
}
\arguments{
\item{x}{Data frame or vector containing categorical variables.}

\item{width}{Integer specifying the maximum width for wrapping text.}

\item{collapse}{Logical specifying whether to merge categories with identical proportions.}

\item{sort}{Logical or character vector. If \code{TRUE}, orders categories by frequency. If \code{FALSE}, orders by names. If a character vector, renames and orders categories accordingly.}

\item{format}{Logical specifying whether to format category names if the input is a vector.}
}
\value{
A tibble with one row per category and the following columns:
\describe{
\item{f}{Factor specifying the category labels, possibly wrapped to the specified width. When
\code{collapse = TRUE}, multiple categories with identical frequencies are
merged into a single label separated by commas.}
\item{n}{Integer specifying the frequency count for each category.}
}
}
\description{
Formats a data frame or vector containing categorical variables and calculates the frequency of each category.
}
\examples{
# Vector of categorical variable
k <- 5
n <- runif(k, 1, 10) \%>\% round()
x <- paste("Level", seq(k)) \%>\%
    mapply(function(x, y) rep(x, y), ., n) \%>\%
    unlist()
count_category(x)

# Data frame of categorical variable
df <- sapply(seq(k), function(x) runif(10) \%>\% round()) \%>\% as.data.frame()
colnames(df) <- paste("Level", seq(k))
count_category(df)
count_category(x, sort = FALSE, width = 5)
count_category(x, sort = seq(k), format = FALSE)
x2 <- c(x, rep("Level 6", n[1]))
count_category(x2, collapse = TRUE)
}
