% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ger_indices.R
\name{ger_GRP}
\alias{ger_GRP}
\title{Germination Seed Percentage}
\usage{
ger_GRP(SeedN, evalName, data)
}
\arguments{
\item{SeedN}{Name of the column with the number of seeds sown.}

\item{evalName}{Prefix of the names of the periods of evaluation.}

\item{data}{The name of the data frame containing the data.}
}
\value{
It returns an vector with the percentage of seed germinated.
}
\description{
This function calculates the germination percentage related at total seed sown for experimental unit.
}
\details{
According GOUVEA LABOURIAU (1983), the germinability of a sample of is the percentage of
seeds in which the seed germination process comes to an end, in experimental conditions by
the seminal intrauterine growth resulting protrusion (or emergence) of a living embryo.
}
\examples{

library(GerminaR)
dt <- prosopis
grp <- ger_GRP(SeedN = "seeds",evalName = "D", data = dt)
grp
}
\references{
LABOURIAU, L. G.; VALADARES, M. E. B. The germination of seeds. OEA, Washington, DC, 1983.
}
