% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoThinned_class.R
\name{as_GeoThinned}
\alias{as_GeoThinned}
\alias{new_GeoThinned}
\alias{print.GeoThinned}
\alias{summary.GeoThinned}
\alias{print.summary.GeoThinned}
\alias{plot.GeoThinned}
\alias{largest}
\alias{largest.GeoThinned}
\alias{largest_index}
\alias{largest_index.GeoThinned}
\alias{get_trial}
\alias{get_trial.GeoThinned}
\alias{as_sf}
\alias{as_sf.GeoThinned}
\title{GeoThinned Object Constructor and Methods}
\usage{
as_GeoThinned(retained, method, params = list(), original_data = NULL)

new_GeoThinned(retained, method, params = list(), original_data = NULL)

\method{print}{GeoThinned}(x, ...)

\method{summary}{GeoThinned}(object, trial = NULL, ...)

\method{print}{summary.GeoThinned}(x, ...)

\method{plot}{GeoThinned}(
  x,
  trial = NULL,
  show_original = TRUE,
  col_original = "#EB714B",
  col_thinned = "#5183B3",
  pch_original = 1,
  pch_thinned = 16,
  main = NULL,
  ...
)

largest(x, ...)

\method{largest}{GeoThinned}(x, ...)

largest_index(x, ...)

\method{largest_index}{GeoThinned}(x, ...)

get_trial(x, trial = NULL, ...)

\method{get_trial}{GeoThinned}(x, trial = NULL, ...)

as_sf(x, ...)

\method{as_sf}{GeoThinned}(x, trial = NULL, crs = 4326, ...)
}
\arguments{
\item{retained}{A list of logical vectors indicating retained points per trial.}

\item{method}{The thinning method used (e.g., "distance", "grid", "precision").}

\item{params}{A list of parameters used in thinning.}

\item{original_data}{The original unmodified data.}

\item{x}{An object of class \code{GeoThinned}.}

\item{...}{Additional arguments (ignored).}

\item{object}{An object of class \code{GeoThinned}.}

\item{trial}{Integer index of the thinning trial to extract (for \code{summary()}, \code{get_trial()}, \code{plot()}, \code{as_sf()}). Default `NULL`, which will return the largest dataset.}

\item{show_original}{Logical, whether to show original points.}

\item{col_original}{Colors for original points.}

\item{col_thinned}{Colors for thinned points.}

\item{pch_original}{Point shapes for original points.}

\item{pch_thinned}{Point shapes for thinned points.}

\item{main}{Title of the plot.}

\item{crs}{Coordinate reference system to assign to the resulting \code{sf} object (optional).}
}
\value{
A \code{GeoThinned} object or associated results (summary, plot, trial subset).
When `thin_points()` is run with `all_trials = FALSE`, the returned object contains only the largest trial; therefore all methods refer to this single subset.
}
\description{
Create and interact with spatial thinning results stored in a GeoThinned object.
}
\details{
When the 's2' package is not installed or the installed version is lower than 1.1.0,
the spatial coverage metric for geographic coordinates from the \code{summary()} is not computed.
This is an optional summary metric and does not affect the thinning process or any other package functionality.
}
\seealso{
\code{\link{thin_points}}
}
