% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/introns.R
\name{extract_introns}
\alias{extract_introns}
\title{Extract Intron Coordinates from GENCODE Annotations}
\usage{
extract_introns(input, verbose = TRUE)
}
\arguments{
\item{input}{A character string specifying the file path to a GTF/GFF3 file, or a data frame containing GTF data. The input must include columns: \code{seqnames}, \code{start}, \code{end}, \code{strand}, \code{type}, and \code{transcript_id}.}

\item{verbose}{Logical. If \code{TRUE} (default), progress messages are printed during execution.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{seqnames}: Chromosome or scaffold name.
\item \code{intron_start}, \code{intron_end}: Genomic start/end positions of the intron.
\item \code{width}: Length of the intron (intron_end - intron_start + 1).
\item \code{gene_id}, \code{transcript_id}, \code{intron_number}: Gene/transcript identifiers and intron position within the transcript.
\item Additional metadata columns from the original GTF (e.g., \code{gene_name}).
}
}
\description{
Processes a GTF file or data frame to extract intron coordinates, including their genomic positions, transcript associations, and metadata. The function handles both positive and negative strands, ensuring correct orientation of intron boundaries. It is designed to work with GENCODE-formatted annotations.
}
\details{
\enumerate{
\item Input Handling: Loads the GTF file if a path is provided; uses the data frame directly if supplied.
\item Exon Filtering: Extracts exon records and classifies them (e.g., first/last exon) if needed.
\item Multi-Exon Transcripts: Removes single-exon transcripts to focus on spliced transcripts.
\item Intron Calculation: Determines intron coordinates by identifying gaps between consecutive exons, adjusting for strand orientation.
\item Output: Returns a data frame with intron coordinates and metadata, sorted by gene and position.
}
}
\examples{
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")

# From a pre-loaded data frame
gtf_v1 <- load_file(file_v1)
introns <- extract_introns(gtf_v1)

}
\seealso{
\code{\link{load_file}}, \code{\link{classify_exons}}
}
