% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instances.R
\name{create_U}
\alias{create_U}
\title{Calculate tumor clone frequencies in samples}
\usage{
create_U(B, m, selection, n_cells = 100)
}
\arguments{
\item{B}{A matrix representing the mutation relationships between the nodes in the phylogenetic tree (B matrix).}

\item{m}{An integer representing the number of samples taken from the tumor.}

\item{selection}{A character string representing the evolutionary mode the tumor follows. This should be either "positive" or "neutral".}

\item{n_cells}{An integer representing the number of cells sampled from the multinomial distribution. Default is 100.}
}
\value{
A matrix where each row corresponds to a sample, and each column corresponds to a clone. The value at the i-th row and j-th column is the frequency of the j-th clone in the i-th sample.
}
\description{
This function calculates the frequencies of each clone in a set of samples, given the global clone proportions in the tumor and their spatial distribution.
}
\examples{

# Create random topology with 20 nodes and k = 3
B <- create_B(20, 3)

# Create U matrix with parameter m=4 and "positive" selection
U <- create_U(B = B, m = 4, selection = "positive")
}
