% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2026-01-21_s4_class_methods.R
\name{galaxy_upload_ftp}
\alias{galaxy_upload_ftp}
\alias{galaxy_upload_ftp,character-method}
\alias{galaxy_upload_ftp,Galaxy-method}
\title{Generic upload ftp}
\usage{
galaxy_upload_ftp(
  x,
  input_file,
  galaxy_ftp = "ftp.usegalaxy.eu",
  galaxy_url = "https://usegalaxy.eu",
  ...
)

\S4method{galaxy_upload_ftp}{character}(
  x,
  input_file,
  galaxy_ftp = "ftp.usegalaxy.eu",
  galaxy_url = "https://usegalaxy.eu",
  ...
)

\S4method{galaxy_upload_ftp}{Galaxy}(
  x,
  input_file,
  galaxy_ftp = "ftp.usegalaxy.eu",
  galaxy_url = "https://usegalaxy.eu",
  ...
)
}
\arguments{
\item{x}{A \code{Galaxy} object, or a \code{history_id} to use the default method.}

\item{input_file}{Path to the local file to upload.}

\item{galaxy_ftp}{FTP server address of the Galaxy instance.}

\item{galaxy_url}{Base URL of the Galaxy instance, used by the default
method. If \code{GALAXY_URL} is set it takes precedence.}

\item{...}{not in use}
}
\value{
For the default method, a character scalar dataset ID. For the
\code{Galaxy} method, the modified \code{Galaxy} object.
}
\description{
\code{galaxy_upload_ftp()} is an S4 generic. With no \code{x} supplied it uploads a
local file via FTP and registers it in the specified history, returning the
encoded dataset ID. When called with a \code{Galaxy} object it uses the
object's \code{history_id} and \code{galaxy_url} and updates the object with the new
\code{input_dataset_id}.
}
\details{
A valid API key (\code{GALAXY_API_KEY}) and FTP credentials (\code{GALAXY_USERNAME},
\code{GALAXY_PASSWORD}) must be available in the environment.
}
\examples{
\dontshow{if (galaxy_has_key() && nzchar(Sys.getenv("GALAXY_USERNAME")) && nzchar(Sys.getenv("GALAXY_PASSWORD"))) withAutoprint(\{ # examplesIf}
galaxy_ftp <- "ftp.usegalaxy.eu"
input_file <- tempfile(fileext = ".txt")
writeLines("Example", input_file)
hid <- galaxy_initialize("test upload")
did <- galaxy_upload_ftp(input_file, hid, galaxy_ftp)
g <- galaxy()
g <- galaxy_initialize(g)
g <- galaxy_upload_ftp(g, input_file, galaxy_ftp = galaxy_ftp)
\dontshow{\}) # examplesIf}
}
