% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alex.pathway.R
\name{alex.pathway}
\alias{alex.pathway}
\title{Visualize Lesion and Expression Data by Pathway}
\usage{
alex.pathway(alex.data, lsn.clrs = NULL, lsn.data, pathways, selected.pathway)
}
\arguments{
\item{alex.data}{Output of the \code{alex.prep.lsn.expr} function. A list of three data tables: \code{"row.mtch"}, \code{"alex.expr"} (expression matrix), and \code{"alex.lsn"} (lesion matrix). Rows in both matrices are ordered by Ensembl gene IDs; columns represent patient IDs.}

\item{lsn.clrs}{Optional. A named vector of colors for lesion types. If not specified, default colors will be assigned using \code{default.grin.colors()}.}

\item{lsn.data}{A data frame of lesion data in GRIN-compatible format with the following columns:
\code{"ID"} (patient ID), \code{"chrom"} (chromosome), \code{"loc.start"} (lesion start), \code{"loc.end"} (lesion end), and \code{"lsn.type"} (e.g., gain, loss, mutation, fusion).}

\item{pathways}{A data frame with three columns: \code{"gene.name"} (gene symbol), \code{"ensembl.id"} (Ensembl gene ID), and \code{"pathway"} (pathway name).}

\item{selected.pathway}{A character string indicating the pathway of interest.}
}
\value{
A list with the following element:
\item{ordered.path.data}{A data frame with lesion and expression data for pathway genes, ordered according to hierarchical clustering (matching the order used in the plot).}

A figure with two panels will also be generated showing:
\enumerate{
\item Lesion data of pathway genes across subjects
\item Expression data of the same genes across subjects
}
Both panels are ordered by subject similarity based on lesion profiles.
}
\description{
Computes pairwise distances between subjects based on lesion profiles in genes associated with a specified pathway, and returns a figure with two panels: one showing lesion data and another showing expression data, both ordered based on the computed distances (useful for hierarchical clustering). It also returns the corresponding ordered data.
}
\details{
This function identifies all genes associated with the specified pathway, extracts lesion and expression data for those genes, and computes pairwise distances between subjects based on their lesion profiles. It uses hierarchical clustering to order the subjects and visualizes lesion and expression matrices in two aligned panels. It also returns a data frame containing the ordered expression and lesion data for all genes in the pathway.
}
\examples{
data(expr_data)
data(lesion_data)
data(hg38_gene_annotation)
data(pathways)

# Prepare matched expression and lesion data
alex.data <- alex.prep.lsn.expr(expr_data, lesion_data,
                                hg38_gene_annotation, min.expr = 5, min.pts.lsn = 5)

# Visualize pathway-level association using JAK pathway as an example
alex.path=alex.pathway(alex.data,
                       lsn.data = lesion_data,
                       pathways = pathways,
                       selected.pathway = "Jak_Pathway")

# Access the ordered data matrix used in the plot
head(alex.path$ordered.path.data)
}
\seealso{
\code{\link{alex.prep.lsn.expr}}, \code{\link[stats]{hclust}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
