param_kmean <-
function(x, k) {
  
  
  
  kmeans_result <- kmeans(x, centers = k, nstart = 10)
  
  mu_init <- kmeans_result$centers 
  cluster <- kmeans_result$cluster
  
  
  p <- ncol(x)  
  sigma_init <- array(0, dim = c(p, p, k)) 
  
  for (i in 1:k) {
    cluster_data <- x[cluster == i, , drop = FALSE]
    sigma_init[ , , i] <- cov(cluster_data)  
  }
  
  
  pi_k <- as.numeric( table(cluster) / nrow(x) )  
  
  return(list( pi_k = pi_k, mu = mu_init, sigma = sigma_init))
}
