
param_CEM <-
  function(x,k,iter = 10){
    n <- nrow(x)  
    x <- X<-  data.frame(x)
    K <- k
    P <- ncol(x)
    

    
    
    kmeans_init <- kmeans(x,k)
    
    pi <- kmeans_init$size/sum(kmeans_init$size)
    mu <- kmeans_init$centers
    #  X <- data.frame(x)
    rownames(x) <- NULL
    X_cluster <- split(x, kmeans_init$cluster) 
    sigma <- array(0, dim = c(P,P,K))
    
    
    for (i in 1:K) {
      X_centered <- sweep(X_cluster[[i]], 2, mu[i,])
      X_centered <- as.matrix(X_centered) 
      sigma[ , ,i] <- (t(X_centered) %*% X_centered) / nrow(X_cluster[[i]])
      
    }
    
    
    ll <- rep(NA,iter)
    pi_iter  <-  vector("list", iter)
    mu_iter   <-  vector("list", iter )
    sigma_iter <- vector("list", iter )
    count = 0
    
    repeat{ 
      count <- count +1
      
      ll[count] <- loglik(x = X , pi = pi, mu = mu , sigma =sigma)
      pi_iter[[count]] <- pi
      mu_iter[[count]]  <- mu
      sigma_iter[[count]]  <- sigma
      
      
      tau <- E.step(x = X , pi = pi, mu = mu , sigma =sigma)
      
      C <-  apply(tau, 1, which.max)
      
      
      
      param <- M.step_sem(x = X, s = C )
      
      pi = param[[1]]
      
      mu  = param[[2]]
      sigma= param[[3]] 
      
      if ( count == iter){
        
        break
      } 
      
      
    }
    
    
   
    
    index <- which.max(ll)
    return(list(
      pi_k = pi_iter[[index]],
      mu    = mu_iter[[index]],
      sigma = sigma_iter[[index]]
    ))
  }
