% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_binfile.R
\name{sample_binfile}
\alias{sample_binfile}
\title{Sample Bin File}
\usage{
sample_binfile(
  binfile,
  binfile_path,
  output_folder,
  start_time = NULL,
  end_time = NULL,
  downsample = TRUE,
  output_csv = FALSE,
  save_raw = FALSE
)
}
\arguments{
\item{binfile}{Text lines read from an open connection to a bin file.}

\item{binfile_path}{Path to the bin file to be processed.}

\item{output_folder}{Path to the folder containing GENEAcore run outputs and Measurement Period Information (MPI) files.}

\item{start_time}{Time stamp to start the read from, default start of file.}

\item{end_time}{Time stamp to end the read from, default end of file.}

\item{downsample}{Logical to determine whether to downsample the file, default TRUE.}

\item{output_csv}{Allow outputs of bin file sampling to be saved as CSV.}

\item{save_raw}{Save daily raw sampled data as RDS to for quicker reprocessing, default FALSE.}
}
\value{
List of 1Hz downsampled data or raw sample data.
}
\description{
Sample Bin File
}
\details{
Function to read in a GENEActiv bin file with option to downsample
to 1Hz. This can read the whole of the file or just a portion of it by
setting the start_time and end_time parameters.
}
\examples{
binfile_path <- system.file("extdata/20Hz_file.bin", package = "GENEAcore")
output_folder <- tempdir()
con <- file(binfile_path, "r")
binfile <- readLines(con, skipNul = TRUE)
close(con)
measurements <- sample_binfile(binfile, binfile_path, output_folder)
}
