% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagnelie_vc22_2.R
\name{dagnelie_vc22_2}
\alias{dagnelie_vc22_2}
\title{Two-entry Dagnelie volume (tarif 2)}
\usage{
dagnelie_vc22_2(data, output = NULL)
}
\arguments{
\item{data}{A \code{data.frame} containing at least the columns
\code{c130} (stem circumference at 1.30 m, in cm),
\code{htot} (height of the tree, in m),
and \code{species_code} (character code of the tree species).}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}
}
\value{
A \code{data.frame} identical to \code{data} but augmented with:
\itemize{
\item the joined columns from \code{dan2}
(\code{coeff_a}, \code{coeff_b}, \code{coeff_c}, \code{coeff_d},
\code{coeff_e}, \code{coeff_f},
\code{min_c130}, \code{max_c130},
\code{min_htot}, \code{max_htot}),
\item \code{tarif2}: the Dagnelie two-entry volume \eqn{v_{c,22}}
in m\eqn{^3} per tree.
}
}
\description{
Computes the standing volume \eqn{v_{c,22}} (in cubic metres) using
Dagnelie's two-entry tarif 2 equations. The volume is calculated from the
stem circumference at 1.30 m (\code{c130}, in cm), the total height of the tree
(\code{htot}, in m), and the tree species, using species-specific polynomial
coefficients stored in \code{dan2}.
}
\details{
The function:
\itemize{
\item checks that the input data frame contains the required columns
\code{c130}, \code{htot} and \code{species_code},

\item validates that all species codes are present in the \code{dan2} table,

\item merges the input data with \code{dan2} to retrieve:
\code{coeff_a}, \code{coeff_b}, \code{coeff_c}, \code{coeff_d},
\code{coeff_e}, \code{coeff_f},
as well as the species-specific valid ranges:
\code{min_c130}, \code{max_c130},
\code{min_htot}, \code{max_htot},

\item issues a warning for trees whose \code{c130} is outside the valid
range \code{[min_c130, max_c130]},

\item issues a warning for trees whose \code{htot} is outside the valid
range \code{[min_htot, max_htot]},

\item computes the tarif 2 volume using the species-specific polynomial:
\deqn{
           v_{c,22} =
           coeff_a +
           coeff_b \cdot c130 +
           coeff_c \cdot c130^2 +
           coeff_d \cdot c130^3 +
           coeff_e \cdot htot +
           coeff_f \cdot c130^2 \cdot htot
        }
}

Species codes must match those available in the \code{dan2} reference table.
If one or more species are not found, the function issues a warning.

For trees where \code{c130} or \code{htot} is outside the species-specific
validity ranges \code{[min_c130, max_c130]} and \code{[min_htot, max_htot]},
warnings are issued, but the volume is still computed.
}
\section{Supported species}{

The following species codes are currently supported by \code{dagnelie_vc22_2}:
\itemize{
\item \code{"QUERCUS_SP"}
\item \code{"QUERCUS_ROBUR"}
\item \code{"QUERCUS_PETRAEA"}
\item \code{"QUERCUS_PUBESCENS"}
\item \code{"QUERCUS_RUBRA"}
\item \code{"FAGUS_SYLVATICA"}
\item \code{"ACER_PSEUDOPLATANUS"}
\item \code{"FRAXINUS_EXCELSIOR"}
\item \code{"ULMUS_SP"}
\item \code{"PRUNUS_AVIUM"}
\item \code{"BETULA_SP"}
\item \code{"ALNUS_GLUTINOSA"}
\item \code{"PICEA_ABIES"}
\item \code{"PSEUDOTSUGA_MENZIESII"}
\item \code{"LARIX_SP"}
\item \code{"PINUS_SYLVESTRIS"}
\item \code{"CRATAEGUS_SP"}
\item \code{"PRUNUS_SP"}
\item \code{"CARPINUS_SP"}
\item \code{"CASTANEA_SATIVA"}
\item \code{"CORYLUS_AVELLANA"}
\item \code{"MALUS_SP"}
\item \code{"PYRUS_SP"}
\item \code{"SORBUS_ARIA"}
\item \code{"SAMBUCUS_SP"}
\item \code{"RHAMNUS_FRANGULA"}
\item \code{"PRUNUS_CERASUS"}
\item \code{"ALNUS_INCANA"}
\item \code{"POPULUSxCANADENSIS"}
\item \code{"POPULUS_TREMULA"}
\item \code{"PINUS_NIGRA"}
\item \code{"PINUS_LARICIO"}
\item \code{"TAXUS_BACCATA"}
\item \code{"ACER_PLATANOIDES"}
\item \code{"ACER_CAMPESTRE"}
\item \code{"SORBUS_AUCUPARIA"}
\item \code{"JUNGLANS_SP"}
\item \code{"TILLIA_SP"}
\item \code{"PICEA_SITCHENSIS"}
\item \code{"ABIES_ALBA"}
\item \code{"TSUGA_CANADENSIS"}
\item \code{"ABIES_GRANDIS"}
\item \code{"CUPRESSUS_SP"}
\item \code{"THUJA_PLICATA"}
\item \code{"AESCULUS_HIPPOCASTANUM"}
\item \code{"ROBINIA_PSEUDOACACIA"}
\item \code{"SALIX_SP"}
}
}

\examples{
df <- data.frame(
  c130         = c(145, 156, 234, 233),
  htot         = c(25, 23, 45, 34),
  species_code = c("PINUS_SYLVESTRIS", "QUERCUS_RUBRA",
                   "QUERCUS_SP", "FAGUS_SYLVATICA")
)
dagnelie_vc22_2(data = df)
}
\seealso{
\code{\link{dan2}} for the species-specific coefficients and ranges.
}
