% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsbootgce.R
\name{tsbootgce}
\alias{tsbootgce}
\title{Time series bootstrap Cross entropy estimation}
\usage{
tsbootgce(
  formula,
  data,
  subset,
  na.action,
  offset,
  contrasts = NULL,
  trim = 0.05,
  reps = 1000,
  start = NULL,
  end = NULL,
  coef.method = c("mode", "median"),
  cv = TRUE,
  cv.nfolds = 5,
  errormeasure = c("RMSE", "MSE", "MAE", "MAPE", "sMAPE", "MASE"),
  errormeasure.which = {
     if (isTRUE(cv)) 
         c("1se", "min", "elbow")
    
    else c("min", "elbow")
 },
  support.method = c("standardized", "ridge"),
  support.method.penalize.intercept = TRUE,
  support.signal = NULL,
  support.signal.vector = NULL,
  support.signal.vector.min = 0.3,
  support.signal.vector.max = 20,
  support.signal.vector.n = 20,
  support.signal.points = c(1/5, 1/5, 1/5, 1/5, 1/5),
  support.noise = NULL,
  support.noise.points = c(1/3, 1/3, 1/3),
  weight = 0.5,
  twosteps.n = 1,
  method = c("dual.BFGS", "dual.lbfgsb3c", "dual", "primal.solnl", "primal.solnp",
    "dual.CG", "dual.L-BFGS-B", "dual.Rcgmin", "dual.bobyqa", "dual.newuoa",
    "dual.nlminb", "dual.nlm", "dual.lbfgs", "dual.optimParallel"),
  caseGLM = c("D", "M", "NM"),
  boot.B = 0,
  boot.method = c("residuals", "cases", "wild"),
  seed = 230676,
  OLS = TRUE,
  verbose = 0
)
}
\arguments{
\item{formula}{a "formula" describing the linear model to be fit. For details
see \code{\link[stats]{lm}} and \code{\link[dynlm]{dynlm}}.}

\item{data}{A \code{\link[base]{data.frame}} (or object coercible by
\code{\link[base]{as.data.frame}} to a data frame) or time series object
(e.g., \code{\link[stats]{ts}} or \code{\link[zoo]{zoo}}), containing the
variables in the model.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of
\code{\link[base]{options}}, and is \code{\link[stats]{na.fail}} if that is
unset. The ‘factory-fresh’ default is \code{\link[stats]{na.omit}}. Another
possible value is \code{NULL}, no action. Value
 \code{\link[stats]{na.exclude}} can be useful.}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting. This should be \code{NULL}
or a numeric vector or matrix of extents matching those of the response. One
or more \code{\link[stats]{offset}} terms can be included in the formula
instead or as well, and if more than one are specified their sum is used.
See \code{\link[stats]{model.offset}}.}

\item{contrasts}{An optional list. See the \code{contrasts.arg} of
\code{\link[stats]{model.matrix.default}}.}

\item{trim}{The trimming proportion (see \code{\link[meboot]{meboot}}).
The default is \code{trim = 0.05}.}

\item{reps}{The number of replicates to generate (see
\code{\link[meboot]{meboot}}). The default is \code{reps = 1000}.}

\item{start}{The time of the first observation. Either a single number
or a vector of two numbers (the second of which is an integer), which
specify a natural time unit and a (1-based) number of samples into the time
unit (see \code{\link[stats]{ts}}).}

\item{end}{The time of the last observation, specified in the same way as
\code{start} (see \code{\link[stats]{ts}}).}

\item{coef.method}{Method used to estimate the coefficients. One of
\code{c("mode", "median")}. for \code{"mode"} see \code{\link[hdrcde]{hdr}}}

\item{cv}{Boolean value. If \code{TRUE} the error, \code{errormeasure},
will be computed using cross-validation. If \code{FALSE} the error will be
computed in sample. The default is \code{cv = TRUE}.}

\item{cv.nfolds}{number of folds used for cross-validation when
\code{cv = TRUE}. The default is \code{cv.nfolds = 5} and the smallest value
allowable is \code{cv.nfolds = 3}.}

\item{errormeasure}{Loss function (error) to be used for the selection
of the support spaces. One of c("RMSE","MSE", "MAE", "MAPE", "sMAPE", "MASE").
The default is \code{errormeasure = "RMSE"}.}

\item{errormeasure.which}{Which value of \code{errormeasure}
to be used for selecting a support space upper limit from \code{support.signal.vector}.
One of \code{c("min", "1se", "elbow")} where \code{"min"} corresponds to the
support spaces that produced the lowest error, \code{"1se"} corresponds to
the support spaces such that error is within 1 standard error of the CV error
for \code{"min"} and \code{"elbow"} corresponds to the elbow point of the error
curve (the point that maximizes the distance between each observation, i.e,
the pair composed by the upper limit of the support space and the error, and
the line between the first and last observations, i.e., the lowest and the
highest upper limits of the support space respectively. See
\code{\link[pathviewr]{find_curve_elbow}}). The default is
\code{errormeasure.which = "1se"}.}

\item{support.method}{One of c("standardized", "ridge"). If
\code{support.method = "standardized}, the default, standardized coefficients
are used to define the signal support spaces. If
\code{support.method = "ridge} the signal support spaces are define by the
ridge trace.}

\item{support.method.penalize.intercept}{Boolean value. if \code{TRUE},
the default, the intercept will be penalized. To be used when
\code{support.method = "ridge"}.}

\item{support.signal}{\code{NULL} or fixed positive upper limit (L) for the
support spaces (-L,L) on standardized data (when
\code{support.method = "standardized"}); \code{NULL} or fixed positive factor
 to be multiplied by the maximum absolute value of the ridge trace for each
 coefficient (when \code{support.method = "ridge"}); a pair (LL,UL) or a
 matrix ((k+1) x 2) for the support spaces on original data. The default is
 \code{support.signal = NULL}.}

\item{support.signal.vector}{NULL or a vector of positive values when
\code{support.signal = NULL}. If \code{support.signal.vector = NULL},
the default, a vector
\code{c(support.signal.vector.min,...,support.signal.vector.max)} of dimension
 \code{support.signal.vector.n} and logarithmically equally spaced will be
generated. Each value represents the upper limits for the standardized support
 spaces, when \code{support.method = "standardized"} or the factor to be
 multiplied by the maximum absolute value of the ridge trace for each
 coefficient, when \code{support.method = "ridge"}.}

\item{support.signal.vector.min}{A positive value for the lowest limit of the
\code{support.signal.vector} when \code{support.signal = NULL} and
\code{support.signal.vector = NULL}. The default is
\code{support.signal.vector.min = 0.3}.}

\item{support.signal.vector.max}{A positive value for the highest limit of the
\code{support.signal.vector} when \code{support.signal = NULL} and
\code{support.signal.vector = NULL}. The default is
\code{support.signal.vector.max = 20}.}

\item{support.signal.vector.n}{A positive integer for the number of support
spaces to be used when \code{support.signal = NULL} and
\code{support.signal.vector = NULL}. The default is
\code{support.signal.vector.n = 20}.}

\item{support.signal.points}{A positive integer, a vector or a matrix. Prior
weights for the signal. If not a positive integer then the sum of weights by
row must be equal to 1. The default is
\code{support.signal.points = c(1 / 5, 1 / 5, 1 / 5, 1 / 5, 1 / 5)}.}

\item{support.noise}{An interval, preferably centered around zero, given in
the form \code{c(LL,UL)}. If \code{support.noise = NULL}, the default, then a
 vector \code{c(-L,L)} is computed using the empirical three-sigma rule
Pukelsheim (1994).}

\item{support.noise.points}{A positive integer, a vector or a matrix. Prior
weights for the noise. If not a positive integer then the sum of weights by
row must be equal to 1. The default is
\code{support.noise.points = c(1 / 3, 1 / 3, 1 / 3)}.}

\item{weight}{a value between zero and one representing the
prediction-precision loss trade-off. If \code{weight = 0.5}, the default,
equal weight is placed on the signal and noise entropies. A higher than 0.5
value places more weight on the noise entropy whereas a lower than 0.5 value
places more weight on the signal entropy.}

\item{twosteps.n}{Number of GCE reestimations using a previously estimated
vector of signal probabilities.}

\item{method}{Use \code{"primal.solnl"} (GCE using Sequential Quadratic
Programming (SQP) method; see \code{\link[NlcOptim]{solnl}}) or
\code{"primal.solnp"} (GCE using the augmented Lagrange multiplier method
with an SQP interior algorithm; see \code{\link[Rsolnp]{solnp}}) for primal
form of the optimization problem and \code{"dual"} (GME), \code{"dual.CG"}
(GCE using a conjugate gradients method; see \code{\link[stats]{optim}}),
\code{"dual.BFGS"} (GCE using Broyden-Fletcher-Goldfarb-Shanno quasi-Newton
method; see \code{\link[stats]{optim}}), \code{"dual.L-BFGS-B"} (GCE using a
box-constrained optimization with limited-memory modification of the BFGS
quasi-Newton method; see \code{\link[stats]{optim}}), \code{dual.Rcgmin}
(GCE using an update of the conjugate gradient algorithm; see
\code{\link[optimx]{optimx}}),
\code{dual.bobyqa} (GCE using a derivative-free optimization by quadratic
approximation; see \code{\link[optimx]{optimx}} and
\code{\link[minqa]{bobyqa}}), \code{dual.newuoa} (GCE using a
derivative-free optimization by quadratic approximation; see
\code{\link[optimx]{optimx}} and \code{\link[minqa]{newuoa}}),
\code{dual.nlminb} (GCE; see \code{\link[optimx]{optimx}} and
\code{\link[stats]{nlminb}}), \code{dual.nlm} (GCE; see
\code{\link[optimx]{optimx}} and \code{\link[stats]{nlm}}),
\code{dual.lbfgs} (GCE using the Limited-memory
Broyden-Fletcher-Goldfarb-Shanno; see \code{\link[lbfgs]{lbfgs}}),
\code{dual.lbfgsb3c} (GCE using L-BFSC-B implemented in Fortran code and with
an Rcpp interface; see \code{\link[lbfgsb3c]{lbfgsb3c}}) or
\code{dual.optimParallel} (GCE using parallel version of the L-BFGS-B; see
\code{\link[optimParallel]{optimParallel}}) for dual form. The
default is \code{method = "dual.BFGS"}.}

\item{caseGLM}{special cases of the generic general linear model. One of
\code{c("D", "M", "NM")}, where "D" stands for data, "M" for moment and
 "NM" for normed-moment The default is \code{caseGLM = "D"}.}

\item{boot.B}{A single positive integer greater or equal to 10 for the number
of bootstrap replicates to be used for the computation of the bootstrap
confidence interval(s). Zero value will generate no replicate. The default
is \code{boot.B = 0}.}

\item{boot.method}{Method to be use for bootstrapping. One of
\code{c("residuals", "cases", "wild")} which corresponds to resampling on
residuals, on individual cases or on residuals multiplied by a N(0,1) variable,
respectively. The default is \code{boot.method = "residuals"}.}

\item{seed}{A single value, interpreted as an integer, for reproducibility
or \code{NULL} for randomness. The default is \code{seed = 230676}.}

\item{OLS}{Boolean value. if \code{TRUE}, the default, OLS estimation is
performed.}

\item{verbose}{An integer to control how verbose the output is. For a value
of 0 no messages or output are shown and for a value of 3 all messages
are shown. The default is \code{verbose = 0}.}
}
\value{
\code{tsbootgce} returns an object of \code{\link[base]{class}} \code{tsbootgce}.
The generic accessory functions \code{\link{coef.tsbootgce}},
 \code{\link{confint.tsbootgce}} and \code{\link{plot.tsbootgce}} extract
 various useful features of the value returned by \code{object} of class
 \code{tsbootgce}.

 An object of \code{\link[base]{class}} \code{tsbootgce} is a list containing at
 least the following components:

\item{call}{the matched call.}
\item{coefficients}{a named data frame of coefficients determined by
 \code{coef.method}.}
\item{data.ts}{\code{ts} object.}
\item{error}{loss function (error) used for the selection of the support
spaces.}
\item{error.measure}{in sample error for the selected support space.}
\item{fitted.values}{the fitted mean values.}
\item{frequency}{see \code{link[zoo]{zoo}}.}
\item{index}{see \code{link[zoo]{zoo}}.}
\item{lmgce}{\code{lmgce} object.}
\item{meboot}{\code{meboot} replicates.}
\item{model}{the model frame used.}
\item{nep}{normalized entropy of the signal of the model.}
\item{nepk}{normalized entropy of the signal of each coefficient.}
\item{residuals}{the residuals, that is response minus fitted values.}
\item{results}{a list containing the bootstrap results: "coef.matrix", a named
 data frame of all the coefficients; "nepk.matrix", a named data frame of all
 the normalized entropy values of each parameter; "nep.vector", a vector of
 all the normalized entropy values of the model.}
\item{seed}{the seed used.}
\item{terms}{the \code{\link[stats]{terms}} object used.}
\item{x}{if requested (the default), the model matrix used.}
\item{xlevels}{(only where relevant) a record of the levels of the factors
used in fitting.}
\item{y}{if requested (the default), the response used.}
}
\description{
This generic function fits a linear regression model using bootstrapped time
series via generalized cross entropy.
}
\details{
The \code{tsbootgce} function fits several linear regression models via
generalized cross entropy in replicas of time series obtained using
\code{\link[meboot]{meboot}}. Models for \code{\link{tsbootgce}} are specified
symbolically (see \code{\link[stats]{lm}} and \code{\link[dynlm]{dynlm}}).
}
\examples{
\donttest{
res.tsbootgce <-
  tsbootgce(
    formula = CO2 ~ 1 + L(GDP, 1) + L(EPC, 1) + L(EU, 1),
    data = moz_ts)

res.tsbootgce
}

}
\references{
Golan, A., Judge, G. G. and Miller, D. (1996)
\emph{Maximum entropy econometrics : robust estimation with limited data.}
Wiley.\cr

Golan, A. (2008)
\emph{Information and Entropy Econometrics — A Review and Synthesis.}
Foundations and Trends® in Econometrics, 2(1–2), 1–145.
\doi{10.1561/0800000004}\cr

Golan, A. (2017)
\emph{Foundations of Info-Metrics: Modeling, Inference, and Imperfect Information (Vol. 1).}
Oxford University Press.
\doi{10.1093/oso/9780199349524.001.0001}\cr

Hyndman, R.J. (1996)
\emph{Computing and graphing highest density regions.}
 American Statistician, 50, 120-126.
 \doi{10.2307/2684423}\cr

Pukelsheim, F. (1994)
\emph{The Three Sigma Rule.}
The American Statistician, 48(2), 88–91.
\doi{10.2307/2684253}\cr

Vinod, H. D., & Lopez-de-Lacalle, J. (2009).
\emph{Maximum Entropy Bootstrap for Time Series: The meboot R Package.}
 Journal of Statistical Software, 29(5), 1–19.
\doi{10.18637/jss.v029.i05}
}
\seealso{
The generic functions \code{\link{plot.tsbootgce}}, \code{\link{print.tsbootgce}},
 and \code{\link{coef.tsbootgce}}.
}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
