% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridgetrace.R
\name{ridgetrace}
\alias{ridgetrace}
\title{Function to obtain the ridge trace and choose the support limits given a
formula}
\usage{
ridgetrace(
  formula,
  data,
  subset,
  na.action,
  offset,
  contrasts = NULL,
  lambda = NULL,
  lambda.min = 0.001,
  lambda.max = 1,
  lambda.n = 100,
  penalize.intercept = TRUE,
  errormeasure = c("RMSE", "MSE", "MAE", "MAPE", "sMAPE", "MASE"),
  cv = TRUE,
  cv.nfolds = 5,
  seed = 230676
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats]{formula}} (or one that
can be coerced to that class): a symbolic description of the model to be
fitted.}

\item{data}{A data frame (or object coercible by
\code{\link[base]{as.data.frame}} to a data frame) containing the variables
 in the model.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action} setting of
\code{\link[base]{options}}, and is \code{\link[stats]{na.fail}} if that is
unset. The ‘factory-fresh’ default is \code{\link[stats]{na.omit}}. Another
possible value is \code{NULL}, no action. Value
 \code{\link[stats]{na.exclude}} can be useful.}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting. This should be \code{NULL}
or a numeric vector or matrix of extents matching those of the response. One
or more \code{\link[stats]{offset}} terms can be included in the formula
instead or as well, and if more than one are specified their sum is used.
See \code{\link[stats]{model.offset}}.}

\item{contrasts}{An optional list. See the \code{contrasts.arg} of
\code{\link[stats]{model.matrix.default}}.}

\item{lambda}{The default is \code{lambda = NULL} and a lambda sequence will
be computed based on \code{lambda.n}, \code{lambda.min} and \code{lambda.max}.
 Supplying a lambda sequence overrides this.}

\item{lambda.min}{Minimum value for the \code{lambda} sequence.}

\item{lambda.max}{Maximum value for the \code{lambda} sequence.}

\item{lambda.n}{The number of lambda values. The default is
\code{lambda.n = 100}.}

\item{penalize.intercept}{Boolean value. if \code{TRUE}, the default, the
intercept will be penalized.}

\item{errormeasure}{Loss function (error) to be used for the selection
of the support spaces. One of c("RMSE","MSE", "MAE", "MAPE", "sMAPE", "MASE").
The default is \code{errormeasure = "RMSE"}.}

\item{cv}{Boolean value. If \code{TRUE} the error, \code{errormeasure},
will be computed using cross-validation. If \code{FALSE} the error will be
computed in sample. The default is \code{cv = TRUE}.}

\item{cv.nfolds}{number of folds used for cross-validation when
\code{cv = TRUE}. The default is \code{cv.nfolds = 5}.}

\item{seed}{A single value, interpreted as an integer, for reproducibility
or \code{NULL} for randomness. The default is \code{seed = 230676}.}
}
\value{
An object of \code{\link[base]{class}} \code{ridgetrace} is a list containing
 at least the following components:

\item{lambda}{the lambda sequence used}
\item{max.abs.coef}{a named vector of coefficients (maximum absolute
coefficients)}
\item{max.abs.residual}{the maximum absolute residual}
\item{coef.lambda}{a data.frame with the coefficients for each lambda tested}
\item{error.lambda}{a vector with the in sample error}
\item{error.lambda.cv}{a data.frame with cross-validation errors}
\item{call}{the matched call}
}
\description{
Function to obtain the ridge trace and choose the support limits given a
formula
}
\examples{
res.ridgetrace <-
  ridgetrace(
    formula = y ~ X001 + X002 + X003 + X004 + X005,
    data = dataGCE)

res.ridgetrace

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
