% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridgetraceclassfunctions.R
\name{coefficients.ridgetrace}
\alias{coefficients.ridgetrace}
\title{Extract \code{\link{ridgetrace}} Model Coefficients}
\usage{
\method{coefficients}{ridgetrace}(object, which = "min.error", ...)
}
\arguments{
\item{object}{Fitted \code{\link{ridgetrace}} model object.}

\item{which}{One of \code{c("min.error", "max.abs")}.  If
\code{which = "min.error"}, the default, the coefficients that produced the
lowest error cross-validation error (\code{cv = TRUE}),or in sample error are
 returned (\code{cv = FALSE}). If \code{which = "max.abs"} then the maximum
 absolute coefficients are returned.}

\item{...}{Additional arguments.}
}
\value{
Returns the coefficients from a \code{ridgetrace} object
}
\description{
Extract coefficients from a \code{\link{ridgetrace}} object
}
\examples{
res.ridgetrace <-
  ridgetrace(
    formula = y ~ X001 + X002 + X003 + X004 + X005,
    data = dataGCE)

coefficients(res.ridgetrace)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
