% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARCHX_select.R
\name{GARCHX_select}
\alias{GARCHX_select}
\title{Variable selection for exogenous covariates in GARCHX models}
\usage{
GARCHX_select(
  eps,
  X,
  order = c(1, 1),
  delta = 2,
  alpha.level = 0.05,
  adjust.method = "fdr",
  optim.method = "NR"
)
}
\arguments{
\item{eps}{Time series data}

\item{X}{Matrix with exogenous covariates where the number of rows is equal to the length of eps}

\item{order}{Order of the GARCH model. Value of p cannot be 0.}

\item{delta}{Value of the power of the main time series to allow for Power GARCHX, default is 2 for GARCHX}

\item{alpha.level}{Alpha level for p-value cut-off in variable selection}

\item{adjust.method}{Multiple testing p-value adjustment, see p.adjust. Possible values are "holm", "hochberg", "hommel", "bonferonni", "BH", "BY", "fdr", "none"}

\item{optim.method}{Optimization method for maximizing quasi-likelihood function. Options: "NR", "L-BFGS-B", "GA", "PS", "SA". Default value is "NR"}
}
\value{
An object of class GARCHX
}
\description{
Performs variable selection on the exogenous covariates through testing each covariate in X and correcting the p-values for multiple testing.
}
\details{
Using the GARCHX model \deqn{\mathcal{E}_t = \sigma_tw_t}
\deqn{\sigma^2_t = \omega_0 + \sum^{p}_{i=1}\alpha_i\mathcal{E}_{t-i}^2 + \sum^q_{j=1}\beta_j\sigma^2_{t-j}+\mathbf{\pi}^T\mathbf{x}_{t-1}}

performs variable selection by testing \deqn{H_0: \pi_j = 0, \forall j}
and compares the p-values to the adjusted alpha level according to adjust.method.
If alpha.level = 1, then no variable selection is performed and the function only estimates the parameters
}
\examples{
set.seed(123)
pi <- c(1, 0, 0, 4)
n <- 2000
d <- length(pi)
valinit <- 100
n2 <- n + d + 1
omega <- 0.1
alpha <- 0.2
beta <- 0.3
delta <- 2
e<-rnorm(n2+valinit)
Y<-e
for (t in 2:n2)
 Y[t]<- 0.2*Y[t-1]+e[t]
x<-exp(Y)
X <- matrix(0, nrow = (n+valinit), ncol = length(pi))
for(j in 1:d)
 X[, j] <- x[(d+2-j):(n+d+1-j+valinit)]
data <- GARCH.X::simulate(n, omega, alpha, beta, delta, X, pi, valinit = valinit)
model <- GARCHX_select(eps = data$eps, X = data$X)

}
\references{
Francq, C. and Thieu, L.Q.(2018). \emph{QML Inference for Volatility Models with Covariates}.
Econometric Theory, Cambridge University Press
}
