% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GAP_function.R
\name{GAP}
\alias{GAP}
\title{Generalized Association Plots (GAP)}
\usage{
GAP(
  data,
  isProximityMatrix = FALSE,
  XdNum = NULL,
  XcNum = NULL,
  YdNum = NULL,
  YcNum = NULL,
  row.name = NULL,
  Xd.name = NULL,
  Xc.name = NULL,
  row.prox = NULL,
  col.prox = NULL,
  show.row.prox = TRUE,
  show.col.prox = TRUE,
  row.order = NULL,
  col.order = NULL,
  row.flip = NULL,
  col.flip = NULL,
  row.externalOrder = NULL,
  col.externalOrder = NULL,
  original.color = NULL,
  row.color = NULL,
  col.color = NULL,
  Xd.color = NULL,
  Xc.color = NULL,
  Yd.color = NULL,
  Yc.color = NULL,
  row.label.size = NULL,
  col.label.size = NULL,
  Xd.label.size = NULL,
  Xc.label.size = NULL,
  Yd.label.size = NULL,
  Yc.label.size = NULL,
  colorbar.margin = 1.5,
  border = FALSE,
  border.width = 1,
  isContainMissingValue = 0,
  MissingValue.color = "gray",
  exp.row_order = FALSE,
  exp.column_order = FALSE,
  exp.row_names = FALSE,
  exp.column_names = FALSE,
  exp.Xc = FALSE,
  exp.Yc = FALSE,
  exp.Xd = FALSE,
  exp.Yd = FALSE,
  exp.Xd_codebook = FALSE,
  exp.Yd_codebook = FALSE,
  exp.originalmatrix = FALSE,
  exp.row_prox = FALSE,
  exp.col_prox = FALSE,
  PNGfilename = NULL,
  PNGwidth = 1800,
  PNGheight = 1200,
  PNGres = 150,
  show.plot = FALSE
)
}
\arguments{
\item{data}{A data frame to be visualized.}

\item{isProximityMatrix}{Logical. Whether the input data is already a proximity matrix.}

\item{XdNum, XcNum, YdNum, YcNum}{Integer vectors specifying discrete/continuous covariates on X and Y axes.}

\item{row.name}{Either a character vector, or an integer vector to be used as row names.}

\item{Xd.name, Xc.name}{Either A string, or a character vector to be used as Xc.name/Xd.name.}

\item{row.prox, col.prox}{A string indicating the method used to compute row/column proximity.}

\item{show.row.prox, show.col.prox}{Logical. Whether to show row/column proximity matrices.}

\item{row.order, col.order}{A string specifying the method used to order rows/columns.}

\item{row.flip, col.flip}{A string specifying the row/column flipping method.}

\item{row.externalOrder, col.externalOrder}{Integer vectors used as external references for flipping.}

\item{original.color}{Color palette for the original data matrix.}

\item{row.color, col.color}{Color palettes for the row/column proximity matrices.}

\item{Xd.color, Xc.color, Yd.color, Yc.color}{Color palettes for covariate matrices.}

\item{row.label.size, col.label.size}{Numeric values controlling the font size of row and column labels.}

\item{Xd.label.size, Xc.label.size, Yd.label.size, Yc.label.size}{Numeric values controlling the font size of covariate labels for X and Y axes.}

\item{colorbar.margin}{Numeric. The margin space between the colorbar and the main plot area.}

\item{border}{Logical. Whether to draw borders around each matrix.}

\item{border.width}{Numeric value specifying border width.}

\item{isContainMissingValue}{Integer. Set to \code{1} if the input data contains missing values; otherwise, use \code{0}.}

\item{MissingValue.color}{Color to represent missing values in the matrix. Default is \code{"gray"}.}

\item{exp.row_order, exp.column_order}{Logical. Whether to export row/column order.}

\item{exp.row_names, exp.column_names}{Logical. Whether to export sorted row/column names.}

\item{exp.Xc, exp.Yc, exp.Xd, exp.Yd}{Logical. Whether to export sorted covariate matrices.}

\item{exp.Xd_codebook, exp.Yd_codebook}{Logical. Whether to export codebooks for discrete covariates.}

\item{exp.originalmatrix}{Logical. Whether to export the reordered original matrix.}

\item{exp.row_prox, exp.col_prox}{Logical. Whether to export computed proximity matrices (after ordering).}

\item{PNGfilename}{A string specifying the output filename for the PNG image.}

\item{PNGwidth, PNGheight}{Width/height of the PNG image in pixels.}

\item{PNGres}{Resolution of the PNG image in DPI.}

\item{show.plot}{Logical. Whether to display the plot in the R graphics window after generation.}
}
\value{
A composite plot (e.g., heatmap with annotations) is saved or displayed. Additional information may be exported based on the settings.

If one or more export-related options (\code{exp.*}) are set to \code{TRUE},
the function returns a list containing the requested components. Each element in the list corresponds to an exportable data object,
}
\description{
Generates a generalized association plot for the given matrix or data frame,
with optional proximity computation, ordering, flipping, coloring, and export options.
}
\details{
\strong{isProximityMatrix}

If \code{isProximityMatrix = TRUE}, you may directly provide a proximity matrix as the input \code{data}.
In this case, the provided proximity matrix is treated as the “original matrix” for visualization;
therefore \code{original.color} and \code{exp.originalmatrix} control the display of the input matrix (i.e., the proximity matrix).
Accordingly, only row-based settings will be applied, such as \code{row.order}, \code{row.flip}, \code{row.externalOrder}, \code{row.name}, \code{row.label.size}, \code{exp.row_order}, and \code{exp.row_names}.
Note that correlation matrices (e.g., \code{"pearson"}) must be converted to distance matrices before being used,
and the selected color scheme must also be one of the supported diverging palettes (e.g., \code{"GAP_Blue_White_Red"}, \code{"BrBG"}, \code{"PiYG"}, \code{"PRGn"}, \code{"PuOr"}, \code{"RdBu"}, \code{"RdGy"}).

\strong{XdNum, XcNum, YdNum, YcNum}

These parameters are used to specify which columns in \code{data} should be treated as covariates
on the X or Y axes. Provide the column indices (e.g., \code{XdNum = c(3, 5)}) of discrete or continuous variables.
Discrete covariates (Xd and Yd) are used as provided in the input data and treated as categorical labels.

\strong{Xd.name, Xc.name}

If not provided, the default labels will be a sequence of numbers based on the number of selected variables (e.g., "1", "2", ..., up to the length of XdNum or XcNum).

\strong{row.name}

This parameter can be:
\itemize{
\item A character vector providing custom row names.
\item An integer (column index) indicating a column in \code{data} to be used as row names.
\item If \code{row.name = NULL}, the row names will be automatically generated as \code{1:nrow(data)}.
}

\strong{row.prox, col.prox}

Available proximity methods for \code{row.prox} and \code{col.prox} include:
\itemize{
\item \code{"euclidean"}
\item \code{"pearson"}
\item \code{"kendall"}
\item \code{"spearman"}
\item \code{"atancorr"} (adjusted tangent correlation)
\item \code{"city-block"} (Manhattan distance)
\item \code{"abs_pearson"}
\item \code{"uncenteredcorr"}
\item \code{"abs_uncenteredcorr"}
\item \code{"maximum"}
\item \code{"canberra"}
}
For binary data, the following methods are supported:
\itemize{
\item \code{"hamman"}
\item \code{"jaccard"}
\item \code{"phi"}
\item \code{"rao"}
\item \code{"rogers"}
\item \code{"simple"}
\item \code{"sneath"}
\item \code{"yule"}
}

\strong{show.row.prox, show.col.prox}

If set to \code{TRUE}, the corresponding proximity matrix will be visualized.
If set to \code{FALSE}, the proximity matrix will not be shown, but the associated proximity and ordering methods will still be applied.
In such cases, the dendrogram (tree structure) will appear alongside the original plot, reflecting the proximity-based ordering.

\strong{row.order, col.order}

The ordering method determines how the rows or columns are reordered. Supported options include:
\itemize{
\item \code{"original"} — Use the original data order.
\item \code{"random"} — Randomly permute the order.
\item \code{"reverse"} — Reverse the original order.
\item \code{"r2e"} — Rank-two ellipse ordering.
\item \code{"single"} — Single-linkage hierarchical clustering.
\item \code{"complete"} — Complete-linkage hierarchical clustering.
\item \code{"average"} — Average-linkage hierarchical clustering (UPGMA).
\item \emph{any method name from the \code{seriation} package} — such as \code{"TSP"}, \code{"Spectral"}, \code{"ARSA"}, etc.
}

If the ordering method is \code{"original"}, \code{"random"}, or \code{"reverse"}, then proximity matrices are not required,
and the parameters \code{row.prox} or \code{col.prox} may be left unset.

For all other ordering methods, a proximity matrix must be computed first.
Therefore, \code{row.prox} or \code{col.prox} must be specified accordingly.

Note: it is necessary to explicitly specify one of the valid ordering options; the function does not assume a default.

\strong{row.flip, col.flip}

Supported flipping methods include:
\itemize{
\item \code{"r2e"} — Flip using the rank-two ellipse (R2E) method.
\item \code{"uncle"} — Apply uncle-flipping based on tree structure.
\item \code{"grandpa"} — Apply grandpa-flipping based on tree structure.
}

\strong{Usage restrictions:}
\enumerate{
\item Flipping is only applicable when a hierarchical clustering tree is generated.
Therefore, if \code{row.order} or \code{col.order} is set to \code{"original"}, \code{"random"}, \code{"reverse"}, \code{"r2e"}, or a seriation method,
tree structures are not built and flipping cannot be applied.

\item When using \code{"r2e"} as the ordering method, only \code{"r2e"} flipping is allowed. \code{"uncle"} or \code{"grandpa"} flipping will be ignored.

\item \strong{Do not specify both \code{externalOrder} and \code{flip} at the same time.} These options are mutually exclusive. If both are provided, the function will throw an error.
}

\strong{row.externalOrder, col.externalOrder}

External orders are used as references when flipping the hierarchical clustering tree.
If a tree is available, the external order guides the flipping of the dendrogram’s leaf nodes to better match a predefined sequence.

\strong{Important:}
Do not use \code{externalOrder} together with \code{flip}; they are mutually exclusive.

\strong{Color settings}

The function supports a variety of color palette options for visualizing the original matrix, proximity matrices, and covariate matrices.

Supported built-in palettes include:
\itemize{
\item \code{"GAP_Rainbow"}
\item \code{"GAP_Blue_White_Red"}
\item \code{"GAP_d"}
\item \code{"grayscale_palette"} (for Binary data)
}

You may also specify any palette name from the \code{RColorBrewer} package.
However, note that some palettes—such as those under the "Qualitative" category—are not suitable for visualizing continuous data like proximity matrices.
For gray-scale representations of continuous matrices, the \code{"Greys"} palette from \code{RColorBrewer} can be used.

All palette names must be passed as character strings (e.g., \code{"GAP_Rainbow"}, \code{"Set1"}).

\strong{original.color}:
The system will automatically determine the appropriate default color palette based on data type.
If the input data is binary, the default is a grayscale palette; otherwise, it defaults to \code{"GAP_Rainbow"}.

\strong{row.color, col.color}:
The system chooses a default palette based on the proximity method used.
For distance-based methods (e.g., \code{"euclidean"}, \code{"city-block"}), the default is \code{"GAP_Rainbow"}.
For correlation-based methods (e.g., \code{"pearson"}, \code{"spearman"}), the default is \code{"GAP_Blue_White_Red"}.

\strong{Xd.color, Yd.color (discrete covariates)}:
The default color palette is \code{"GAP_d"}, which supports up to 16 distinct categories.
If there are more than 16 unique levels, a custom palette should be provided by the user.

\strong{Label size settings}

Font sizes for axis labels and covariate matrices can be customized individually.
Default values are:
\itemize{
\item \code{row.label.size}: 2
\item \code{col.label.size}: 8
\item \code{Xd.label.size, Xc.label.size, Yd.label.size, Yc.label.size}, \code{Xc.label.size}: 8
}

You may increase or decrease these values to improve readability depending on figure size and resolution.

\strong{Export-related options (\code{exp.*})}

When any of the \code{exp.*} parameters are set to \code{TRUE}, the corresponding data will be stored in a list and returned by the function.
This allows users to programmatically retrieve the order, reordered matrix, proximity matrices, covariate data, or codebooks after plotting.

\strong{PNG output settings}

The following parameters control the export of the PNG image:

\itemize{
\item \code{PNGfilename}: The name of the PNG file to be saved.
\itemize{
\item The file extension \code{.png} must be included manually (e.g., \code{"myplot.png"}).
\item If no file path is specified, the image will be saved in a system-generated temporary directory (via \code{tempdir()}) using the default filename \code{"output_plot.png"}.
\item To save the image to a specific location, provide the full path (e.g., \code{"C:/.../myplot.png"}).
}
\item \code{PNGwidth}: Width of the output image in pixels. Default = 1800.
\item \code{PNGheight}: Height of the output image in pixels. Default = 1200.
\item \code{PNGres}: Resolution (dots per inch, DPI). Default = 150.
}
}
\examples{
# Example using the crabs dataset from the MASS package
if (requireNamespace("MASS", quietly = TRUE)) {
  df_crabs <- MASS::crabs
  CRAB_result <- GAP(
    data = df_crabs,
    YdNum = c(1,2),        # First two columns as Y discrete covariates
    YcNum = 3,             # Third column as Y continuous covariate
    row.name = c(1,2,3),   # Use First three columns as row names
    row.prox = "euclidean",
    col.prox = "euclidean",
    row.order = "average",
    col.order = "average",
    row.flip = "r2e",
    col.flip = "r2e",
    border = TRUE,
    border.width = 1,
    exp.row_order = TRUE,
    exp.column_order = TRUE,
    exp.row_names = TRUE,
    exp.column_names = TRUE,
    exp.Yd_codebook = TRUE,
    exp.Yd = TRUE,
    exp.Yc = TRUE,
    exp.originalmatrix = TRUE,
    exp.row_prox = TRUE,
    exp.col_prox = TRUE,
    PNGfilename = file.path(tempdir(), "output_plot.png"),
    show.plot = TRUE
  )

  # Access exported results:
  CRAB_result$row_order       # Row order after ordering
  CRAB_result$column_order    # Column order after ordering
  CRAB_result$row_names       # Row names after ordering
  CRAB_result$column_names    # Column names after ordering
  CRAB_result$Yd_codebook     # Codebook for Y discrete covariates
  CRAB_result$Yd              # Y discrete covariates after ordering
  CRAB_result$Yc              # Y continuous covariates after ordering
  CRAB_result$originalmatrix  # Original matrix (after ordering)
  CRAB_result$row_prox        # Row proximity matrix (after ordering)
  CRAB_result$col_prox        # Column proximity matrix (after ordering)

  # Evaluate row ordering quality
  AR(CRAB_result$row_prox)
  GAR(CRAB_result$row_prox, w = 10)
  RGAR(CRAB_result$row_prox, w = 10)

}
}
