% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{gace_forecast}
\alias{gace_forecast}
\title{GACE Forecasting Engine (Generalized Adaptive Capped Estimator)}
\usage{
gace_forecast(
  df,
  periods = 12,
  freq = c("week", "month", "quarter", "year"),
  seasonal = TRUE,
  cap_low = -0.3,
  cap_high = 0.3,
  verbose = FALSE
)
}
\arguments{
\item{df}{Numeric vector or time series of historical values.}

\item{periods}{Integer; number of future periods to forecast.}

\item{freq}{One of \code{"week"}, \code{"month"}, \code{"quarter"},
or \code{"year"}. Used when \code{df} is not a \code{ts} object, and
also informs the growth/seasonal logic.}

\item{seasonal}{Logical; whether to apply seasonal scaling.}

\item{cap_low}{Numeric; baseline lower growth cap.}

\item{cap_high}{Numeric; baseline upper growth cap.}

\item{verbose}{Logical; if TRUE, prints diagnostic messages.}
}
\value{
A data frame with columns:
\itemize{
\item \code{period} – integer index of historical and forecast periods,
\item \code{value} – observed or forecast values,
\item \code{type} – "historical" or "forecast".
}
The returned object has S3 class \code{"gace_forecast"} and includes
engine details in the \code{"gace_details"} attribute.
}
\description{
Deterministic forecasting method combining hybrid growth signals,
volatility-aware asymmetric caps, and optional seasonal scaling.
Supports weekly, monthly, quarterly, and yearly time series.
}
\details{
This is the main user-facing function. It wraps the internal engine and
returns a data frame suitable for plotting and downstream analysis.
}
\examples{
\donttest{
  set.seed(1)
  y <- ts(rnorm(60, mean = 100, sd = 10), frequency = 12)
  fc <- gace_forecast(y, periods = 12, freq = "month")
  head(fc)
}

}
