# Collection of data

#' Simulated data 1
#'
#' A dataset containing y, f1, f2 based on one of McCracken (2019)'s data generating processes.
#' The name of the specification is "Unconditional-Rolling".
#' R = 175, Rbar = 175, h = 12, P = 75;
#' Note that the DGP is constructed in a way that there is no difference between f1 and f2 in terms of expected quadratic loss.
#' @format A data frame with 75 rows and 3 variables:
#' \describe{
#' \item{y}{Forecast target}
#' \item{f1}{Point forecast based on forecasting model 1}
#' \item{f2}{Point forecast based on forecasting model 2}
#' }
#' @source Simulated data.
"mikedata"

#' Civilian Unemployment Rate (UNEMP)
#'
#' Error Statistics for the Survey of Professional Forecasters for Unemployment Rate
#'
#' @format `UNEMP`
#' A data frame with 219 rows and 31 columns
#' @source <https://www.philadelphiafed.org/-/media/frbp/assets/surveys-and-data/survey-of-professional-forecasters/data-files/unemp/data_spf_error_statistics_unemp_1_aic.xls?la=en&hash=4CAD0B11FEAB6C4D0F30C38965FE3354>
"UNEMP"

#' 3-Month Treasury Bill Rate (TBILL)
#'
#' Error Statistics for the Survey of Professional Forecasters for Treasury Bill Rate (Three Month)
#'
#' @format `TBILL`
#' A data frame with 219 rows and 31 columns
#' @source <https://www.philadelphiafed.org/-/media/frbp/assets/surveys-and-data/survey-of-professional-forecasters/data-files/tbill/data_spf_error_statistics_tbill_1_aic.xls?la=en&hash=F432350F84B0E4CCE9A1E9D399447CA9>
"TBILL"

#' Real Gross National Product/Gross Domestic Product (RGDP)
#'
#' Error Statistics for the Survey of Professional Forecasters for Real GNP/GDP
#'
#' @format `RDGP`
#' A data frame with 219 rows and 31 columns
#' @source <https://www.philadelphiafed.org/-/media/frbp/assets/surveys-and-data/survey-of-professional-forecasters/data-files/rgdp/data_spf_error_statistics_rgdp_3_aic.xls?la=en&hash=3AC9E2D8A5299F93CA7E16CFAA974C22>
"RGDP"

#' Price Index for Gross National Product/Gross Domestic Product (PGDP)
#'
#' Error Statistics for the Survey of Professional Forecasters for GNP/GDP Price Index
#'
#' @format `PGDP`
#' A data frame with 219 rows and 31 columns
#' @source <https://www.philadelphiafed.org/-/media/frbp/assets/surveys-and-data/survey-of-professional-forecasters/data-files/pgdp/data_spf_error_statistics_pgdp_3_aic.xls?la=en&hash=148987D03D54DA5391A44F28CBC12729>
"PGDP"
