% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.station.metadata.R
\name{add.station.metadata}
\alias{add.station.metadata}
\title{Add MetaData to Database}
\usage{
add.station.metadata(
  Agency,
  StationID,
  StnName,
  StateProv = NA,
  Country,
  Lat,
  Lon,
  CatchmentArea_km2 = NA,
  RHN = FALSE,
  StationID_Alternate = NA,
  Overwrite = FALSE
)
}
\arguments{
\item{Agency}{string indicating the source of the streamflow data, e.g. USGS, 
WSC, etc. Cannot be NA, but can be any user-specified string, e.g. "Agency A".}

\item{StationID}{string, cannot be NA.}

\item{StnName}{string, cannot be NA.}

\item{StateProv}{string, State, Province, or Territory. Can be NA.}

\item{Country}{string, can be an abbreviation, e.g. USA, CA, or full name.}

\item{Lat}{numeric indicating latitude (in decimal degrees) for the gauge location. Can be NA.}

\item{Lon}{numeric indicating longitude (in decimal degrees) for the gauge location. Can be NA.}

\item{CatchmentArea_km2}{numeric, the total drainage area in square kilometers.}

\item{RHN}{TRUE or FALSE indication of whether the station is part of a reference hydrologic network, 
representing a catchment that has minimal human impacts. Default is FALSE.}

\item{StationID_Alternate}{Optional alternate station ID, default is NA.}

\item{Overwrite}{Indication of whether a record in the metadata should be overwritten if a match is found. 
Match is based on the Agency AND StationID. Default is FALSE.}
}
\description{
Adds user-supplied station metadata to package database. Can also be used to update
metadata for a station that is already present in the metadata.
}
\examples{
\dontrun{
met_added <- add.station.metadata(
  Agency = "Foo Bar",
  StationID = "01234",
  StnName = "Example Station",
  Country = NA,
  Lat = 40.0,
  Lon = -89.0
)
}
}
\author{
Jennifer Dierauer
}
