% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sim_g3plus3.R
\name{run_sim_g3plus3}
\alias{run_sim_g3plus3}
\title{Simulations for the G3 design.}
\usage{
run_sim_g3plus3(p.true,
                  mtd.true,
                  ncohort,
                  cohortsize = 3,
                  startdose = 1,
                  n.earlystop = 100,
                  ntrial = 1000,
                  seed = 6)
}
\arguments{
\item{p.true}{a vector or matrix containing the true toxicity probabilities of the investigational dose levels.}

\item{mtd.true}{a numeric value or a vector which specifies the true MTD.}

\item{ncohort}{a numeric value; the total number of cohorts.}

\item{cohortsize}{a numeric value; the cohort size.}

\item{startdose}{a numeric value; the starting dose level for the trial.}

\item{n.earlystop}{a numeric value; the early stopping parameter. If the number of participants
treated at the current dose reaches \code{n.earlystop},
stop the trial and select the MTD based on the observed data.
The default value \code{n.earlystop=100} essentially turns
off this type of early stopping.}

\item{ntrial}{a numeric value; the total number of simulated trials.}

\item{seed}{a numeric value; the random seed for simulation.}
}
\value{
\code{run_sim_g3plus3()} returns:

(1) a dataframe (\code{$selection}) with each column showing:
       the numbered index for each scenarios specified,
       the name of the design,
       the selection percentage at each dose level,
       the percentage of early stopping without selecting the MTD,
       the percentage of overdosing selection (POS),
       the percentage of correct selection (PCS),
       the percentage of underdosing selection (PUS),
       the numbered index for the true MTD, respectively.

(2) a dataframe (\code{$allocation}) with each column showing:
       the numbered index for each scenarios specified,
       the name of the design,
       the number of participants treated at each dose level,
       the average number of participants treated,
       the percentage of overdosing assignment (POA),
       the percentage of correct assignment (PCA),
       the percentage of underdosing assignment (PUA),
       the numbered index for the true MTD, respectively.

(3) a list (\code{$setup}) containing user input parameters.
}
\description{
Conduct computer simulations for the G3 design.
}
\details{
Denote the current dose \eqn{d}. Let \eqn{n_d} and \eqn{y_d} represent the
          number of participants treated at dose \eqn{d} and the number of participants
          experienced DLT, respectively. Let \eqn{p_d} be the toxicity probability at
          dose \eqn{d}. Also, denote \eqn{\frac{y_d}{n_d}} the observed toxicity rate
          at the current dose.

          The G3 design uses the following decision rules. For \eqn{n} is three or six,
          we simply apply the 3+3 rules; otherwise, we use the following decision rules,
          with EI being [0.2, 0.29]. If \eqn{\frac{y_d}{n_d}} is lower than the escalation
          boundary (i.e. below the EI), the decision is to escalate to the next higher dose;
          if \eqn{\frac{y_d}{n_d}} is between the escalation and de-escalation boundaries
          (between the EI), the decision is to stay at the current dose; if
          \eqn{\frac{y_d}{n_d}} is higher than the de-escalation boundary (i.e. above
          the EI), the decision is to de-escalate to the next lower dose.

          Also, the G3 design includes a dose exclusion rule. If \eqn{Pr(p_d > 0.25 | y_d , n_d ) > 0.95},
          dose \eqn{d} and those higher than \eqn{d} are removed from the trial since
          they are deemed excessively toxic.

          Three rules (1)-(3) with which G3 selects the final MTD after the trial is completed.
          (1) After removing doses based on the dose exclusion rule in (b), at the end of the
          trial, G3 selects the highest tested dose for which the decision is to de-escalate.
          (2) If no tested doses have a decision to de-escalate (meaning their decisions are
          either escalate or stay), G3 selects the highest tested dose as the MTD. (3) If the
          lowest dose has a decision to de-escalate, no dose is selected as the MTD.

          The G3 design has two early stopping rules: (1) stop the trial if the lowest
         dose is eliminated due to toxicity, and no dose should be selected as the MTD; and
         (2) stop the trial and select the MTD if the number of participants treated at the current
         dose reaches \code{n.earlystop}.
}
\examples{
run_sim_g3plus3(p.true = c(0.25, 0.41, 0.45, 0.49, 0.53),
           mtd.true = c(1,0,0,0,0),
           ncohort = 9,
           cohortsize = 3,
           startdose = 1,
           n.earlystop = 100,
           ntrial = 1000,
           seed = 6)

}
\references{
To be added
}
