% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_x_pred}
\alias{impute_x_pred}
\title{Impute Missing Values in Test Data Using Training Data}
\usage{
impute_x_pred(object, x_test, x_train)
}
\arguments{
\item{object}{A fitted model object with an "imputed" attribute indicating columns to impute.}

\item{x_test}{A matrix or data frame containing the test data.}

\item{x_train}{A matrix or data frame containing the training data.}
}
\value{
A matrix with imputed values and additional columns for missingness indicators.
}
\description{
Imputes missing values in the test data using median imputation based on the training set.
}
\examples{
\donttest{
set.seed(123)
x_test <- matrix(rnorm(60), 10, 6)
colnames(x_test) <- paste0("X", 1:6)
x_test[1:2, 1] <- NA  # Introduce missing values
x_train <- matrix(rnorm(300), 50, 6)
colnames(x_train) <- paste0("X", 1:6)
model <- list(imputed = c(1))
attr(model, "imputed") <- c(1)
x_imputed <- impute_x_pred(model, x_test, x_train)
dim(x_imputed)  # 10 rows, 7 columns (6 original + 1 missingness indicator)
any(is.na(x_imputed))  # FALSE, no missing values
}
}
