\name{schedastic.test}
\alias{schedastic.test}
\title{Test on the effect of concomitant covariate on the extremes of the response variable}
\usage{
schedastic.test(data, k, M = 1000L, xg, ng, bayes = TRUE, C = 5L, alpha = 0.05)
}
\arguments{
\item{data}{design matrix of dimension \code{n} by \code{2} containing the complete data for the dependent variable (first column) and covariate (second column) in [0,1]}

\item{k}{integer, number of exceedances for the generalized Pareto}

\item{M}{integer, number of samples to draw from the posterior distrinution of the law of the concomitant covariate. Default: 1000}

\item{xg}{vector of covariate grid of dimension \code{ng} by \code{1} containing a sequence between zero and the last value of the corresponding covariate}

\item{ng}{length of covariate grid}

\item{bayes}{logical indicating the bootstrap method. If \code{FALSE}, a frequentist bootstrap on the empirical cumulative distribution function of the concomitant covariate is performed. Default to \code{TRUE}}

\item{C}{integer, hypermparameter entering the posterior distributyion of the law of the concomitant covariate. Default: 5}

\item{alpha}{double, significance level for the critical value of the test, computed as the \eqn{(1-alpha)} level empirical quantile of the sample of distances between the empirical cumulative distribution function of the concomitant and complete covariate. Default: 0.05}
}
\value{
a list with components
\itemize{
\item \code{Delta} maximum observed distance between the empirical distribution functions of the concomitant and complete covariate
\item \code{DeltaM} vector of length M containing the sample of maximum distances between the empirical distribution function of the concomitant complete covariate
\item \code{critical} double, critical value for the test statistic, computed as the \eqn{(1-alpha)} level empirical quantile of DeltaM
\item \code{pval} double, p-value
}
}
\description{
Given observed data, perform a Kolmogorov-Smirnov type test comparing the cumulative distribution function of the concomitant covariate, defined as \eqn{X \mid Y > t}, with \eqn{t} being the threshold,
against the cumulative distribution function of the random vector of covariate.
}
\keyword{internal}
