% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rEL.R
\name{rEL}
\alias{rEL}
\title{Random Sample Generation of the Extended Laplace Distribution}
\usage{
rEL(n, mu, sigma, delta)
}
\arguments{
\item{n}{Integer. Sample size.}

\item{mu}{Numeric. Location parameter.}

\item{sigma}{Numeric. Scale parameter (must be > 0).}

\item{delta}{Numeric. Uniform noise parameter (must be > 0).}
}
\value{
A numeric vector of random samples from the Extended Laplace distribution.
}
\description{
Generates random samples from the Extended Laplace distribution using the convolution representation: \eqn{Y = X + U}, where \eqn{X \sim \text{Laplace}(\mu, \sigma)} and \eqn{U \sim \text{Uniform}(-\delta, \delta)}.
}
\examples{
rEL(10, mu = 0, sigma = 1, delta = 0.5)
}
\references{
Saah, D. K., & Kozubowski, T. J. (2025). A new class of extended Laplace distributions with applications to modeling contaminated Laplace data. \emph{Journal of Computational and Applied Mathematics}. \doi{10.1016/j.cam.2025.116588}
}
