test_that("levels and counts are correct", {
  DF <- BuildCIinput()
  CIframe <- BinomialCIsByCategorical(DF, "binVar", "catVar", 1)
  tbl <- table(DF$catVar)
  expect_setequal(as.character(CIframe$Level),
                  names(tbl))
  expect_equal(CIframe$nTotal, as.numeric(tbl))
  index <- which(DF$binVar == 1)
  xTbl <- table(DF[index, "catVar"])
  expect_equal(CIframe$nWith, as.numeric(xTbl))
})
test_that("statistics are correct",{
  DF <- BuildCIinput()
  CIframe <- BinomialCIsByCategorical(DF, "binVar", "catVar", 1)
  tbl <- table(DF$catVar)
  nValues <- as.numeric(tbl)
  index <- which(DF$binVar == 1)
  xTbl <- table(DF[index, "catVar"])
  xValues <- as.numeric(xTbl)
  n <- nrow(CIframe)
  pEst <- vector("numeric", n)
  loCI <- vector("numeric", n)
  upCI <- vector("numeric", n)
  for (i in 1:n){
    CIobj <- PropCIs::addz2ci(xValues[i], nValues[i], 0.95)
    pEst[i] <- CIobj$estimate
    loCI[i] <- CIobj$conf.int[1]
    upCI[i] <- CIobj$conf.int[2]
  }
  expect_equal(CIframe$pEst, pEst)
  expect_equal(CIframe$loCI, loCI)
  expect_equal(CIframe$upCI, upCI)
})
test_that("object class is correct",{
  DF <- BuildCIinput()
  CIframe <- BinomialCIsByCategorical(DF, "binVar", "catVar", 1)
  expect_s3_class(CIframe, c("BinomCIframe", "data.frame"))
})
