% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.BinomCIframe.R
\name{plot.BinomCIframe}
\alias{plot.BinomCIframe}
\title{Plot binomial confidence intervals}
\usage{
\method{plot}{BinomCIframe}(x, ..., CIrange = NULL, addRef = TRUE)
}
\arguments{
\item{x}{an S3 object of class BinomCIframe}

\item{...}{optional named parameters to be passed to \code{\link[=plot]{plot()}}}

\item{CIrange}{two-element vector giving the minimum and maximum y-axis
values to plot (default NULL uses minimum lower confidence limit and
maximum upper confidence limit from \code{x})}

\item{addRef}{logical: add a reference line at the average probability
of a positive response? (default = TRUE)}
}
\value{
None: this method generates a plot from \code{x}
}
\description{
Plot method for the S3 object class BinomCIframe generated by the
\code{\link[=BinomialCIsByCategorical]{BinomialCIsByCategorical()}} function
}
\examples{
catVar <- c(rep("A", 100), rep("B", 100), rep("C", 100))
binVar <- c(rep(0,80),rep(1,20), rep(0,50),rep(1,50), rep(0,20),rep(1,80))
DF <- data.frame(catVar = catVar, binVar = binVar)
CIframe <- BinomialCIsByCategorical(DF, "binVar", "catVar", 1)
plot(CIframe)
}
