% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizeInliers.R
\name{SummarizeInliers}
\alias{SummarizeInliers}
\title{Summarize elements of a numerical vector that occur unusually often}
\usage{
SummarizeInliers(x, label = NULL, labelName = NULL, t = 3)
}
\arguments{
\item{x}{numerical vector in which inliers are to be detected}

\item{label}{optional identifying tag for inliers (default NULL gives
an index into the elements of \code{x} declared inliers)}

\item{labelName}{optional name for the \code{label} column, if specified
(default NULL labels this column as Case)}

\item{t}{detection threshold for the three-sigma edit rule applied to
record counts (default value 3)}
}
\value{
Data frame with one row for each inlier detected and two columns:
\itemize{
\item Record (or \code{labelName} value) identifying or characterizing each inlier
\item Value the numerical value that occurs unusually often
}

Note that this data frame is empty (0 rows) if no inliers are detected
}
\description{
Applies the three-sigma edit rule to the frequencies of distinct values
of a numerical vector, finding those that occur unusually often and
identifying them either by record number or an associated identifying
characteristic specified by \code{label}.  Inliers often represent data
values that are incorrect but consistent with the overall data distribution,
as in the case of numerically-coded disguised missing data
}
\examples{
x <- seq(-1, 1, length = 100)
x[45:54] <- 0
SummarizeInliers(x)
}
