% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareCategoricalLevels.R
\name{CompareCategoricalLevels}
\alias{CompareCategoricalLevels}
\title{Compare categorical level distribution between subsets}
\usage{
CompareCategoricalLevels(
  DF,
  catVar,
  indexA,
  indexB = NULL,
  cLevel = 0.95,
  includeNA = "ifany"
)
}
\arguments{
\item{DF}{A data frame containing \code{catVar}}

\item{catVar}{Categorical variable whose distribution is compared between two subsets}

\item{indexA}{Defines records in the first subset}

\item{indexB}{Defines records in the second subset; default NULL uses all records not in the first subset}

\item{cLevel}{Confidence level for estimated probability differences}

\item{includeNA}{Missing data handling option: \code{ifany} (the default), \code{no} or \code{always}}
}
\value{
Data frame with one row for each \code{catVar} level and these 10 columns:
\itemize{
\item \code{Level} the \code{catVar} level
\item \code{xA} the number of times \code{Level} appears in the first subset
\item \code{nA} the total records in the first subset
\item \code{xB} the number of times \code{Level} appears in the second subset
\item \code{nB} the total records in the second subset
\item \code{pA} the estimated probability that \code{Level} appears in the first subset
\item \code{pB} the estimated probability that \code{Level} appears in the second subset
\item \code{loCI} the lower confidence limit on the difference \code{pA - pB}
\item \code{upCI} the upper confidence limit on the difference \code{pA - pB}
\item \code{signif} a logical indicator of whether \code{pA - pB} is significantly different from zero
}
}
\description{
Given two data subsets, defined by \code{indexA} and \code{indexB}, and a
categorical variable \code{catVar}, compute the probability that each
level of \code{catVar} appears in each subset and the Agresti-Caffo
confidence interval for the difference in these probabilities,
based on the \link[PropCIs:wald2ci]{PropCIs::wald2ci} function.
}
\examples{
catVar <- c(rep("a", 100), rep("b", 100), rep("c", 100))
auxVar <- c(rep("Set1", 30), rep("Set2", 70),
           rep("Set1", 50), rep("Set2", 50),
           rep("Set1", 90), rep("Set2", 10))
DF <- data.frame(catVar = catVar, auxVar = auxVar)
indexA <- which(DF$auxVar == "Set1")
CompareCategoricalLevels(DF, "catVar", indexA)
}
