% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ST&P_Rates.R
\name{clade_membership}
\alias{clade_membership}
\title{Designate clade membership for each tip for downstream analyses summarizing rates for each clade}
\usage{
clade_membership(tree, ancestral_nodes, other_nodes_label = "other_nodes")
}
\arguments{
\item{tree}{Tree object (file path to a Nexus file) used to extract node numbers and tip labels.}

\item{ancestral_nodes}{A named list specifying the MRCA node number for each clade.
The names are the clade labels. To specify non-monophyletic groups, use a character string
in the format \code{"inclusive_node - exclusive_node"}.}

\item{other_nodes_label}{A label to assign to tips not included in any clade defined by \code{ancestral_nodes}.}
}
\value{
A data frame with columns: \code{node} (node number), \code{ancestral_node} (source MRCA node),
and \code{clade} (clade label). Each row represents the clade assignment of a node in the tree.
}
\description{
Designate clade membership for each tip for downstream analyses summarizing rates for each clade
}
\examples{
\dontrun{
ancestral_nodes <- list(
  Non_lepidosauria = 242,
  Other_Lepidosauria = 237,
  Gekkota = 222,
  Scincoidea = 210,
  Teiioidea = 192,
  Lacertidae = 209,
  Amphisbaenia = 205,
  Anguiformes = 150,
  Acrodonta = 145,
  Pleurodonta = 133,
  Caenophidia = 170,
  Early_Serpentes = "164 - 170"  # non-monophyletic group
)

Nodes_Clade_Table <- clade_membership(
  tree = "tree.nex",
  ancestral_nodes = ancestral_nodes,
  other_nodes_label = "deep_Squamata_nodes"
)
}

}
