% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scv.evaluate.core.R
\name{scv.evaluate.core}
\alias{scv.evaluate.core}
\title{Synthetic Variation Coefficient}
\usage{
scv.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
The Synthetic Variation Coefficient values for EC and CS
}
\description{
Compute the Synthetic Variation Coefficient
(\mjteqn{CV\\\%}{CV\\\\\\\%}{CV\%})
\insertCite{dong_exploration_1998,dong_genetic_2001}{EvaluateCore} to compare
quantitative traits of the entire collection (EC) and core set (CS).
}
\details{
Synthetic Variation Coefficient (\mjteqn{CV\\\%}{CV\\\\\\\%}{CV\%})
\insertCite{dong_exploration_1998,dong_genetic_2001}{EvaluateCore} is
computed as follows for the core set (CS).

\mjtdeqn{CV(\\\%) = \left ( \frac{1}{n} \sum_{i=1}^{n} \frac{SE_{i}}{\mu_{i}}
\right ) \times 100}{CV(\\\\\\\%) = \left ( \frac{1}{n} \sum_{i=1}^{n}
\frac{SE_{j}}{\mu_{i}}  \right ) \times 100}{CV(\%) = \left ( \frac{1}{n} \sum_{i=1}^{n} \frac{SE_{j}}{\mu_{i}}  \right ) \times 100}

Where, \mjseqn{SE_{i}} is the standard error of the \mjseqn{i}th trait,
\mjseqn{\mu_{i}} is the mean of the \mjseqn{i}th trait and \mjseqn{n} is the
total number of traits.
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                      function(x) factor(as.factor(x)))

scv.evaluate.core(data = ec, names = "genotypes",
                  quantitative = quant, selected = core)

}
\references{
\insertAllCited{}
}
