% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.evaluate.core.R
\name{corr.evaluate.core}
\alias{corr.evaluate.core}
\title{Phenotypic Correlations}
\usage{
corr.evaluate.core(data, names, quantitative, qualitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A list with the following components. \item{Correlation Matrix}{The
  matrix with phenotypic correlations between traits in EC (below diagonal)
  and CS (above diagonal).} \item{Correologram}{A correlogram of phenotypic
  correlations between traits in EC (below diagonal) and CS (above diagonal)
  as a \code{ggplot} object.} \item{Mantel Correlation}{A data frame with
  Mantel correlation coefficient (\mjseqn{r}) between EC and CS phenotypic
  correlation matrices, it's p value and significance (*: p \mjseqn{\leq}
  0.01; **: p \mjseqn{\leq} 0.05; ns: p \mjseqn{ > } 0.05).}
}
\description{
Compute phenotypic correlations \insertCite{pearson_note_1895}{EvaluateCore}
between traits, plot correlation matrices as correlograms
\insertCite{friendly_corrgrams_2002}{EvaluateCore} and calculate mantel
correlation \insertCite{legendre_interpretation_2012}{EvaluateCore} between
them to compare entire collection (EC) and core set (CS).
}
\note{
Missing values are ignored for the computation of correlation
  coefficient.
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

corr.evaluate.core(data = ec, names = "genotypes", quantitative = quant,
                   qualitative = qual, selected = core)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{cor}},
  \code{\link[ggcorrplot:ggcorrplot]{cor_pmat}}
  \code{\link[ggcorrplot]{ggcorrplot}}, \code{\link[vegan]{mantel}}
}
