% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isgr_index.R
\name{isgr}
\alias{isgr}
\title{ISGR - Genetic Selection Index for Resilience}
\usage{
isgr(GEN, ENV, NG, MG, CICLO, req = 3.5, stage = NULL)
}
\arguments{
\item{GEN}{Column referring to genotypes. Lines must have the prefix 'L' before
the number. Ex: L139.}

\item{ENV}{The column for the selection environment.}

\item{NG}{Number of grains of all genotypes evaluated}

\item{MG}{Grain mass of all genotypes evaluated}

\item{CICLO}{Number of days in the cycle to define rainfall
ideal (value of 3.5 mm per day). Can be changed manually in the 'req' argument.}

\item{req}{Average daily water demand for the soybean crop (standard 3.5 mm).
May change depending on the phenological stage.}

\item{stage}{Parameter to define the phenological stage the crop is in
Use 'veg' for vegetative and 'rep' for reproductive, if the
evaluations have only been carried out in a given period.}
}
\value{
The ISGR - Genetic Selection Index for Resilience defines the ability
of genotypes to express their productivity components under the conditions of
 air temperature and rainfall offered by the environment. The lower the index,
  the more resilient the genotype.
}
\description{
Estimation of the selection index for environmental resilience
(Bandeira et al., 2024).
}
\examples{
library(EstimateBreed)

#Obtain environmental deviations
data("desvamb")
head(desvamb)

#Use DPclim for the ISGR function to identify deviations correctly
DPclim <- with(desvamb,desv_clim(ENV,TMED,PREC))

#Calculate the ISGR
data("genot")
head(genot)
isgr_index <- with(genot, isgr(GEN,ENV,NG,MG,CICLO))

#Define the water requirement per stage
isgr_index <- with(genot, isgr(GEN,ENV,NG,MG,CICLO,req=5,stage="rep"))
}
\references{
Bandeira, W. J. A., Carvalho, I. R., Loro, M. V., da Silva, J. A. G.,
Dalla Roza, J. P., Scarton, V. D. B., Bruinsma, G. M. W., & Pradebon, L. C. (2024).
Identifying soybean progenies with high grain productivity and stress resilience
to abiotic stresses. Aust J Crop Sci, 18(12), 825-830.
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
