% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_ts_main.R
\name{ts_pmm2}
\alias{ts_pmm2}
\title{Fit a time series model using the PMM2 method}
\usage{
ts_pmm2(
  x,
  order,
  model_type = c("ar", "ma", "arma", "arima"),
  method = "pmm2",
  max_iter = 50,
  tol = 1e-06,
  include.mean = TRUE,
  initial = NULL,
  na.action = na.fail,
  regularize = TRUE,
  reg_lambda = 1e-08,
  verbose = FALSE
)
}
\arguments{
\item{x}{Numeric vector of time series data}

\item{order}{Model order specification:
- For AR models: a single integer (AR order)
- For MA models: a single integer (MA order)
- For ARMA models: vector c(p, q) (AR and MA orders)
- For ARIMA models: vector c(p, d, q) (AR, differencing, and MA orders)}

\item{model_type}{String specifying the model type: "ar", "ma", "arma", or "arima"}

\item{method}{String: estimation method, one of "pmm2" (default), "css", "ml", "yw", "ols"}

\item{max_iter}{Integer: maximum number of iterations for the algorithm}

\item{tol}{Numeric: tolerance for convergence}

\item{include.mean}{Logical: whether to include a mean (intercept) term}

\item{initial}{List or vector of initial parameter estimates (optional)}

\item{na.action}{Function for handling missing values, default is na.fail}

\item{regularize}{Logical, add small values to diagonal for numerical stability}

\item{reg_lambda}{Regularization parameter (if regularize=TRUE)}

\item{verbose}{Logical: whether to print progress information}
}
\value{
An S4 object \code{TS2fit} of the corresponding subclass
}
\description{
Fit a time series model using the PMM2 method
}
\details{
The PMM2 algorithm works as follows:
\enumerate{
\item Fits an initial model using a standard method (OLS, Yule-Walker, CSS or ML)
\item Computes central moments (m2, m3, m4) from initial residuals/innovations
\item Uses these moments with a specialized solver (pmm2_algorithm) to find
robust parameter estimates
}
}
