% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmm2_main.R
\name{lm_pmm2}
\alias{lm_pmm2}
\title{PMM2: Main function for PMM2 (S=2)}
\usage{
lm_pmm2(
  formula,
  data,
  max_iter = 50,
  tol = 1e-06,
  regularize = TRUE,
  reg_lambda = 1e-08,
  na.action = na.fail,
  weights = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{R formula for the model}

\item{data}{data.frame containing variables in the formula}

\item{max_iter}{integer: maximum number of iterations for the algorithm}

\item{tol}{numeric: tolerance for convergence}

\item{regularize}{logical: add small value to diagonal for numerical stability}

\item{reg_lambda}{numeric: regularization parameter (if regularize=TRUE)}

\item{na.action}{function for handling missing values, default is na.fail}

\item{weights}{optional weight vector (not yet implemented)}

\item{verbose}{logical: whether to print progress information}
}
\value{
S4 object of class \code{PMM2fit}
}
\description{
Fits a linear model using the Polynomial Maximization Method (order 2),
which is robust to non-Gaussian errors.
}
\details{
The PMM2 algorithm works as follows:
\enumerate{
\item Fits ordinary least squares (OLS) regression to obtain initial estimates
\item Computes central moments (m2, m3, m4) from OLS residuals
\item Iteratively improves parameter estimates using a gradient-based approach
}

PMM2 is especially useful when error terms are not Gaussian.
}
\examples{
set.seed(123)
n <- 80
x <- rnorm(n)
y <- 2 + 3 * x + rt(n, df = 3)
dat <- data.frame(y = y, x = x)

fit <- lm_pmm2(y ~ x, data = dat)
summary(fit, formula = y ~ x, data = dat)
}
