% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_agents.R
\name{calculate_agents}
\alias{calculate_agents}
\title{Calculate Required Number of Agents
This function calculates the required number of agents to achieve a specified service level and occupancy.}
\usage{
calculate_agents(
  call_count,
  call_period,
  avg_handle_time,
  target_anser_time,
  require_service_level,
  max_occupancy,
  shrinkage,
  max_agents = NULL
)
}
\arguments{
\item{call_count}{Numeric. The total number of incoming calls.}

\item{call_period}{Duration. The time period over which calls are counted.}

\item{avg_handle_time}{Duration. The average time taken to handle a call.}

\item{target_anser_time}{Duration. The targeted time to answer a call.}

\item{require_service_level}{Numeric. The required service level.}

\item{max_occupancy}{Numeric. The maximum allowed occupancy level .}

\item{shrinkage}{Numeric. The shrinkage factor to account for non-productive time .}

\item{max_agents}{Integer. The maximum number of agents allowed.}
}
\value{
A list containing the calculated metrics and the number of agents required.
}
\description{
Calculate Required Number of Agents
This function calculates the required number of agents to achieve a specified service level and occupancy.
}
\examples{
calculate_agents(
  call_count = 100,
  call_period = lubridate::duration(30, "minutes"),
  avg_handle_time = lubridate::duration(180, "seconds"),
  target_anser_time = lubridate::duration(20, "seconds"),
  require_service_level = 0.8,
  max_occupancy = 0.85,
  shrinkage = 0.3,
  max_agents = 200
)
}
