% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_sparse_pmf_tail}
\alias{check_sparse_pmf_tail}
\title{Check that PMF tail is not sparse}
\usage{
check_sparse_pmf_tail(pmf, span = 5, tol = 1e-06)
}
\arguments{
\item{pmf}{A probability mass function vector}

\item{span}{The number of consecutive indices in the tail to check}

\item{tol}{The value which to consider the tail as sparse}
}
\value{
Called for its side effects.
}
\description{
Checks if the tail of a PMF vector has more than \code{span}
consecutive values smaller than \code{tol} and throws a warning if so.
}
\keyword{internal}
