% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_core.R
\name{trainer_core_conf_label}
\alias{trainer_core_conf_label}
\title{Confidence level label helper}
\usage{
trainer_core_conf_label(conf_level, fallback = "the reported")
}
\arguments{
\item{conf_level}{Numeric in (0,1), or NA/NULL.}

\item{fallback}{Character string to use when \code{conf_level} is missing.
Default is \code{"the reported"}.}
}
\value{
A character scalar such as \code{"95\%"} or the fallback string.
}
\description{
Returns a short label for a confidence level, e.g. "95%".
If \code{conf_level} is \code{NA} or \code{NULL}, returns \code{fallback}.
}
\examples{
trainer_core_conf_label(0.95)
trainer_core_conf_label(NA)
trainer_core_conf_label(NULL, fallback = "not reported")
}
