% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_core.R
\name{trainer_core_audience_profile}
\alias{trainer_core_audience_profile}
\title{Build an audience profile (beginner / applied / advanced) with optional summary-only mode}
\usage{
trainer_core_audience_profile(
  audience = c("beginner", "applied", "advanced"),
  alpha = 0.05,
  summary_only = FALSE
)
}
\arguments{
\item{audience}{Character: one of c("beginner","applied","advanced").}

\item{alpha}{Numeric alpha (only to instruct the LLM; no computation).}

\item{summary_only}{Logical; if TRUE, enforce a short 3-bullet executive summary
regardless of audience depth.}
}
\value{
List with flags, tone, and guardrails:
  - audience, summary_only, tone
  - show_verbatim, show_diagnostics
  - include_df, include_equations
  - max_bullets, max_words_takeaway
  - guard, alpha_round
}
\description{
Build an audience profile (beginner / applied / advanced) with optional summary-only mode
}
\examples{
trainer_core_audience_profile("applied", 0.05, summary_only = FALSE)
}
