% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ham}
\alias{ham}
\title{Ham: sensory descriptors and overall liking}
\format{
A data frame with 21 rows (hams) and 15 variables:
\describe{
  \item{Juiciness}{numeric}
  \item{Crispy}{numeric}
  \item{Tenderness}{numeric}
  \item{Pasty}{numeric}
  \item{Fibrous}{numeric}
  \item{Salty}{numeric}
  \item{Sweet}{numeric}
  \item{Meaty}{numeric}
  \item{Seasoned}{numeric}
  \item{Metallic}{numeric}
  \item{Ammoniated}{numeric}
  \item{Fatty}{numeric}
  \item{Braised}{numeric}
  \item{Lactic}{numeric}
  \item{Overall liking}{numeric; overall acceptability score}
}
}
\usage{
data(ham)
}
\description{
Sensory profile of hams (quantitative attributes) and an overall liking score.
Useful to illustrate multiple regression and the joint reading of per-term F
tests and coefficient T tests.
}
\details{
Brief summary (indicative): median Juiciness ~ 3.0; median Tenderness ~ 6.0;
mean Salty ~ 5.52; median Overall liking ~ 6.5.
}
\examples{
data(ham)
summary(ham)

\dontshow{if (requireNamespace("FactoMineR", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Multiple regression without selection (FactoMineR):
fit <- FactoMineR::LinearModel(
  `Overall liking` ~ .,
  data = ham,
  selection = "none"
)
print(fit)
\dontshow{\}) # examplesIf}
}
\keyword{datasets}
