% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{deforestation}
\alias{deforestation}
\title{River deforestation: air and water temperatures before/after}
\format{
A data frame with 56 rows and 3 variables:
\describe{
  \item{Temp_water}{numeric; water temperature (deg C).}
  \item{Temp_air}{numeric; air temperature (deg C).}
  \item{Deforestation}{factor with 2 levels: "BEFORE", "AFTER". 28 periods each.}
}
}
\usage{
data(deforestation)
}
\description{
Monitoring data of water and air temperatures before and after riparian
deforestation. Useful to illustrate linear regression with an interaction
(Temp_air * Deforestation).
}
\details{
Brief summary (indicative): Temp_water min ~ 0.55, median ~ 9.28, max ~ 18.89;
Temp_air min ~ -3.04, median ~ 6.53, max ~ 15.75.
}
\examples{
data(deforestation)
str(deforestation)
table(deforestation$Deforestation)

\dontshow{if (requireNamespace("FactoMineR", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Linear model with interaction (FactoMineR):
fit <- FactoMineR::LinearModel(
  Temp_water ~ Temp_air * Deforestation,
  data = deforestation,
  selection = "none"
)
print(fit)
\dontshow{\}) # examplesIf}
}
\keyword{datasets}
