% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{specify_variables}
\alias{specify_variables}
\title{Specify Variable Types for Dynamical Analysis}
\usage{
specify_variables(
  data,
  endogenous = NULL,
  endogenous_coupled = NULL,
  coupled = NULL,
  exogenous = NULL,
  slow_parameter = NULL,
  time = NULL,
  time_col = NULL
)
}
\arguments{
\item{data}{A data.frame containing the time series data.}

\item{endogenous}{Character vector of endogenous state variable names.}

\item{endogenous_coupled}{Character vector of coupled endogenous variables.}

\item{coupled}{Alias for endogenous_coupled (for compatibility).}

\item{exogenous}{Character vector of exogenous forcing variable names.}

\item{slow_parameter}{Character vector of slowly-varying parameter names.}

\item{time}{Name of the time column (auto-detected if NULL).}

\item{time_col}{Alias for time (for compatibility).}
}
\value{
The input data.frame with variable specifications added as the
"var_spec" attribute.
}
\description{
Classifies variables in a dataset according to their role in the dynamical
system being studied.
}
\details{
Variable types:
\itemize{
\item \strong{endogenous}: Variables whose dynamics are modeled (appear as dZ/dt).
\item \strong{endogenous_coupled}: Variables that co-evolve with endogenous vars.
\item \strong{exogenous}: Variables that influence the system but are not modeled.
\item \strong{slow_parameter}: Variables that change on much longer timescales.
}
}
\examples{
data <- data.frame(
  time = 1:10,
  profit_rate = runif(10),
  capital_stock = runif(10),
  interest_rate = runif(10)
)

data <- specify_variables(data,
  endogenous = "profit_rate",
  endogenous_coupled = "capital_stock",
  exogenous = "interest_rate"
)
attr(data, "var_spec")

}
