% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploration.R
\name{plot_surface_3d}
\alias{plot_surface_3d}
\title{3D Response Surface}
\usage{
plot_surface_3d(
  data,
  x_var,
  y_var,
  z_var,
  type = c("contour", "filled_contour", "persp"),
  n_grid = 30,
  method = "loess"
)
}
\arguments{
\item{data}{Data frame.}

\item{x_var}{First predictor variable.}

\item{y_var}{Second predictor variable.}

\item{z_var}{Response variable (target).}

\item{type}{Plot type: "contour", "filled_contour", or "persp".}

\item{n_grid}{Grid resolution for surface estimation.}

\item{method}{Surface fitting method: "loess", "gam", or "linear".}
}
\value{
A plot (base graphics for persp, ggplot for contour).
}
\description{
Creates a 3D surface or contour plot showing how the target variable
depends on two predictors.
}
