\name{EQUAL_encrypt_generate_keys}
\alias{EQUAL_encrypt_generate_keys}
\title{
Generate the encryption keys
}
\description{
"Generates the public and private encryption keys using \pkg{openssl}.
This uses the asymmetric RSA algorithm 4096 bits for generating the keys.
These keys are used for encrypting and decrypting data and files and for
inserting and verifying digital signatures."
}
\usage{
EQUAL_encrypt_generate_keys(public_key_folder, private_key_folder, key_name)
}
\arguments{
\item{public_key_folder}{Location to store the public key}
\item{private_key_folder}{Location to store the private key}
"\item{key_name}{Name of the key (a single name for both public and
private keys)}"
}
\value{
\item{private_key}{private key generated by the algorithm}
\item{public_key}{public key generated by the algorithm}
}
\references{
\url{https://sites.google.com/view/equal-group/home}
}
\author{
Kurinchi Gurusamy
}
\note{
This is part of a suite of functions required to allow encrypting and
decrypting whole files and encrypting and decrypting columns of data
programs to run. This is unlikely to be used as a stand alone function.
}
\seealso{
\code{\link[openssl:rsa_keygen]{openssl::rsa_keygen()}}
}
\concept{EQUALencrypt}
\examples{
test_folder <- tempfile(pattern = "folder_")
public_key_folder <- paste0(test_folder, "/public_key_folder")
private_key_folder <- paste0(test_folder, "/private_key_folder")
dir.create(test_folder)
dir.create(public_key_folder)
dir.create(private_key_folder)
results <- EQUAL_encrypt_generate_keys(
  public_key_folder = public_key_folder,
  private_key_folder = private_key_folder,
  key_name = "encryption_key.txt")
}
